(function ($) {
    'use strict';

    var get_url = function (endpoint) {
        return ovic_core_params.ovic_ajax_url.toString().replace(
            '%%endpoint%%',
            endpoint
        );
    };

    /* NOIFICATIONS */
    if (typeof ovic_core_params.growl_notice != "undefined") {

        $.fn.ovic_add_notify = function ($text_content) {
            var $config        = [],
                $img_url       = '',
                $template_html = '',
                $this          = $(this),
                $img           = $this.closest('.product-item').find('img.wp-post-image'),
                $title         = $this.attr('aria-label'),
                template       = wp.template('ovic-notice-popup');

            $config.duration = ovic_core_params.growl_notice.growl_duration;
            $config.title    = ovic_core_params.growl_notice.growl_notice_text;

            $this.removeClass('loading');

            // if from mini cart
            if ($this.closest('.mini_cart_item').length) {
                $img   = $this.closest('.mini_cart_item').find('a > img');
                $title = $this.closest('.mini_cart_item').find('a:not(.remove)').clone().children().remove().end().text();
            }
            // if from wishlist
            if (!$img.length && $this.closest('.wishlist_table').length) {
                $img = $this.closest('tr').find('.product-thumbnail img');
            }
            // if from pinmap
            if (!$img.length && $this.closest('.ovic-pin').length) {
                $img = $this.closest('.ovic-pin').find('.ovic-product-thumbnail img');
            }
            // if from single product page
            if (!$img.length && $this.closest('.single-product').length) {
                $img = $this.closest('.single-product').find('.product .woocommerce-product-gallery__wrapper img.wp-post-image');
            }
            // if from default woocommerce
            if (!$img.length && $this.closest('.product').length) {
                $img = $this.closest('.product').find('img');
            }
            if (typeof $title === 'undefined' || $title === '') {
                $title = $this.closest('.product').find('.summary .product_title').text();
            }

            // reset state after 5 sec
            setTimeout(function () {
                $this.removeClass('added').removeClass('recent-added');
                $this.next('.added_to_cart').remove();
            }, 3000, $this);

            if (typeof $title === 'undefined' || $title === '') {
                $title = $this.closest('.product-item').find('.product-title:first a').text().trim();
            }

            if (typeof $title !== 'undefined' && $title !== '') {
                var string_start = $title.indexOf("“") + 1,
                    string_end   = $title.indexOf("”");

                $title = string_start > 1 ? $title.slice(string_start, string_end) : $title;
            } else {
                $title = '';
            }

            if ($img.length) {
                $img_url = $img.attr('src');
            }

            $template_html = template({
                img_url: $img_url,
                content: $text_content,
                title  : $title
            });
            $template_html = $template_html.replace('/*<![CDATA[*/', '');
            $template_html = $template_html.replace('/*]]>*/', '');

            $config.message = $template_html;

            $.growl.notice($config);
        };

        $(document).on('removed_from_cart', function (event, fragments, cart_hash, $button) {

            $button.ovic_add_notify(
                ovic_core_params.growl_notice.removed_cart_text
            );

        });

        $(document).on('added_to_cart', function (event, fragments, cart_hash, $button) {

            $button.ovic_add_notify(
                ovic_core_params.growl_notice.added_to_cart_text + '</br>' +
                '<a href="' + ovic_core_params.cart_url + '">' +
                ovic_core_params.growl_notice.view_cart + '</a>'
            );

        });

        $(document).on('added_to_wishlist removed_from_wishlist', function (event, $button) {

            var html       = '',
                product_id = $button.data('product-id'),
                target     = product_id !== undefined ? $('.add-to-wishlist-' + product_id) : $button,
                is_remove  = $button.hasClass('delete_item') || $button.hasClass('remove') ? true : false,
                message    = ovic_core_params.growl_notice.added_to_wishlist_text;

            if (is_remove === true) {
                message = ovic_core_params.growl_notice.removed_from_wishlist_text;
            }

            html += message + '</br>';
            html += '<a href="' + ovic_core_params.growl_notice.wishlist_url + '">';
            if (is_remove === false) {
                html += ovic_core_params.growl_notice.browse_wishlist_text;
            }
            html += '</a>';

            target.ovic_add_notify(html);

            $button.removeClass('loading');

        });

        $(document).on('click', function (event) {
            var target = $(event.target).closest('#growls-default'),
                parent = $('#growls-default');

            if (!target.length) {
                $('.growl-close').trigger('click');
            }
        });

    }

    /* ADD TO CART SINGLE PRODUCT */

    if (ovic_core_params.ajax_single_add_to_cart) {

        var serializeObject = function (form) {
            var o = {};
            var a = form.serializeArray();
            $.each(a, function () {
                if (o[this.name]) {
                    if (!o[this.name].push) {
                        o[this.name] = [o[this.name]];
                    }
                    o[this.name].push(this.value || '');
                } else {
                    o[this.name] = this.value || '';
                }
            });
            return o;
        };

        $(document).on('submit', '.product:not(.product-type-external) form.cart', function (e) {

            var form        = $(this),
                data        = serializeObject(form),
                $thisbutton = form.find('.single_add_to_cart_button');

            if (!$thisbutton.hasClass('disabled')) {

                if ($thisbutton.val()) {
                    data.product_id = $thisbutton.val();
                }

                $thisbutton.addClass('loading');

                // Trigger event.
                $(document.body).trigger('adding_to_cart', [$thisbutton, data]);

                // Ajax action.
                $.post(get_url('add_to_cart_single'), data, function (response) {

                    $thisbutton.removeClass('loading');

                    if (!response) {
                        return;
                    }

                    // Redirect to cart option
                    if (ovic_core_params.cart_redirect_after_add === 'yes' || $thisbutton.hasClass('buy-now')) {
                        window.location = ovic_core_params.cart_url;
                        return;
                    }

                    // Trigger event so themes can refresh other areas.
                    $(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash, $thisbutton]);

                });
                e.preventDefault();

            }
        });

    }

    $(document).on('click', 'form.cart .product-buy-now', function (e) {
        var $this  = $(this),
            $form  = $this.closest('form'),
            $input = $form.find('[name="buy-now-redirect"]');

        if (ovic_core_params.ajax_single_add_to_cart) {
            $(document).on('added_to_cart', function (fragments, cart_hash, button) {
                window.location = ovic_core_params.cart_url;
            });
        } else {
            $input.val(1).trigger('change');
        }
        $form.find('[type="submit"]').trigger('click');

        e.preventDefault();
    });

    /* LOAD MORE POST */

    $.fn.ovic_load_post = function () {
        var is_busy        = false,
            previousScroll = 0,
            is_load        = function ($button, $url, $response, $pagination) {

                var $max_page = $pagination.find('.button-loadmore').data('total');

                $pagination.addClass('loading');
                $.ajax({
                    type    : 'GET',
                    url     : $url,
                    data    : {
                        ovic_raw_content: 1,
                    },
                    success : function (response) {
                        if (!response) {
                            return;
                        }
                        var $html    = $.parseHTML(response, document, true),
                            $nav     = $('.pagination-nav', $html).length ? $('.pagination-nav', $html)[0].innerHTML : '',
                            $content = $($button.data('response'), $html).length ? $($button.data('response'), $html)[0] : '',
                            $current = $('.pagination-nav', $html).find('.button-loadmore').data('current'),
                            $items   = $($content).children();

                        if ($content !== '') {
                            if ($button.data('animate') !== '') {
                                $items.each(function (i) {
                                    var $item  = $(this),
                                        $style = $item.attr('style'),
                                        $delay = i * 100;

                                    $style = ($style === undefined) ? '' : $style;
                                    $item.attr('style', $style +
                                                        ';-webkit-animation-delay:' + $delay + 'ms;' +
                                                        '-moz-animation-delay:' + $delay + 'ms;' +
                                                        '-o-animation-delay:' + $delay + 'ms;' +
                                                        'animation-delay:' + $delay + 'ms;'
                                    ).addClass($button.data('animate') + ' animated').one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
                                        $item.removeClass($button.data('animate') + ' animated');
                                        $item.attr('style', $style);
                                    });
                                    $response.append($item);
                                });
                            } else {
                                $response.append($content.innerHTML);
                            }
                            is_busy = false;
                            $response.trigger('ovic_success_load_more_post', [$content, $html]);
                        } else {
                            is_busy = true;
                        }
                        if ($current >= $max_page) {
                            $pagination.closest('.pagination-nav').remove();
                        } else {
                            $pagination.html($nav);
                            $pagination.removeClass('loading');
                        }
                    },
                    complete: function () {
                        $response.trigger('ovic_complete_load_more_post');
                    }
                });
            };

        $(document).on('click', '.pagination-nav.type-load_more .button-loadmore', function (e) {
            e.preventDefault();
            var $this       = $(this),
                $url        = $this.data('url'),
                $contain    = $this.closest($this.data('wrapper')),
                $response   = $contain.find($this.data('response')),
                $pagination = $this.closest('.pagination-nav');

            is_load($this, $url, $response, $pagination);
        });

        if ($('.pagination-nav.type-infinite .button-loadmore').length) {

            $(document).on('scroll', function () {

                var $this       = $('.pagination-nav.type-infinite .button-loadmore'),
                    $url        = $this.data('url'),
                    $contain    = $this.closest($this.data('wrapper')),
                    $response   = $contain.find($this.data('response')),
                    $pagination = $this.closest('.pagination-nav');

                var currentScroll = $(this).scrollTop();

                if (currentScroll > previousScroll) {

                    if ($pagination.length && $(window).scrollTop() + $(window).height() >= $pagination.offset().top) {

                        if (is_busy === false) {
                            is_load($this, $url, $response, $pagination);
                        }
                        is_busy = true;
                    }
                }

                previousScroll = currentScroll;

            });

        }
    };

    /* LAZY LOAD */

    if (ovic_core_params.enable_lazy) {

        $.fn.ovic_init_lazy_load = function () {

            $(this).each(function () {
                var config = [],
                    image  = $(this),
                    slick  = image.closest('.owl-slick');

                config.beforeLoad     = function (element) {
                    if (element.is('div') == true) {
                        element.addClass('loading-lazy');
                    } else {
                        element.parent().addClass('loading-lazy');
                    }

                    element.trigger('ovic_before_init_lazy_load');
                };
                config.afterLoad      = function (element) {
                    if (element.is('div') == true) {
                        element.removeClass('loading-lazy');
                    } else {
                        element.parent().removeClass('loading-lazy');
                    }
                    element.removeClass('ovic-lazy');

                    element.trigger('ovic_after_init_lazy_load');
                };
                config.effect         = 'fadeIn';
                config.enableThrottle = true;
                config.throttle       = 250;
                config.effectTime     = 600;
                config.threshold      = 300;

                if (image.closest('.megamenu, .flex-viewport').length) {
                    config.delay = 600;
                }

                if (slick.not('.lazy-slick').length) {
                    slick.on('beforeChange', function (event, slick, currentSlide) {
                        $(event.target).find('.ovic-lazy').lazy(config);
                    });
                    slick.addClass('lazy-slick');
                }

                image.lazy(config);

                image.trigger('ovic_init_lazy_load', config);
            });

        };

        $(document).ajaxComplete(function (event, xhr, settings) {
            if (xhr.status == 200 && xhr.responseText) {
                if ($('.ovic-lazy').length) {
                    $('.ovic-lazy').ovic_init_lazy_load();
                }
            }
        });

    }

    window.addEventListener("load", function load() {
        /**
         * remove listener, no longer needed
         * */
        window.removeEventListener("load", load, false);
        /**
         * start functions
         * */

        if ($('.pagination-nav .button-loadmore').length) {
            $('.pagination-nav .button-loadmore').ovic_load_post();
        }

        if ($('.ovic-lazy').length && $.fn.ovic_init_lazy_load) {
            $('.ovic-lazy').ovic_init_lazy_load();
        }

    }, false);

    if (ovic_core_params.is_preview) {
        //
        // Elementor scripts
        //
        $(window).on('elementor/frontend/init', function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/global', function ($scope, $) {
                if ($scope.find('.ovic-lazy').length && $.fn.ovic_init_lazy_load) {
                    $scope.find('.ovic-lazy').ovic_init_lazy_load();
                }
            });
        });
    }

})(window.jQuery);