<?php
/**
 * Settings for MoMo Standard Gateway.
 *
 * @package WooCommerce\Classes\Payment
 */

defined('ABSPATH') || exit;

return array(
    'enabled'               => array(
        'title'   => __('Enable/Disable', 'woocommerce'),
        'type'    => 'checkbox',
        'label'   => __('Enable MoMo Checkout', 'woocommerce'),
        'default' => 'no',
    ),
    'title'                 => array(
        'title'       => __('Title', 'woocommerce'),
        'type'        => 'text',
        'description' => __('This controls the title which the user sees during checkout.', 'woocommerce'),
        'default'     => __('MoMo', 'woocommerce'),
        'desc_tip'    => true,
    ),
    'description'           => array(
        'title'       => __('Description', 'woocommerce'),
        'type'        => 'text',
        'desc_tip'    => true,
        'description' => __('This controls the description which the user sees during checkout.', 'woocommerce'),
        'default'     => __("Pay via MoMo; you can pay with your credit card if you don't have a MoMo account.", 'woocommerce'),
    ),
    'email'                 => array(
        'title'       => __('MoMo email', 'woocommerce'),
        'type'        => 'email',
        'description' => __('Please enter your MoMo email address; this is needed in order to take payment.', 'woocommerce'),
        'default'     => get_option('admin_email'),
        'desc_tip'    => true,
        'placeholder' => 'you@youremail.com',
    ),
    'advanced'              => array(
        'title'       => __('Advanced options', 'woocommerce'),
        'type'        => 'title',
        'description' => '',
    ),
    'debug'                 => array(
        'title'       => __('Debug log', 'woocommerce'),
        'type'        => 'checkbox',
        'label'       => __('Enable logging', 'woocommerce'),
        'default'     => 'no',
        /* translators: %s: URL */
        'description' => sprintf(__('Log MoMo events, such as IPN requests, inside %s Note: this may log personal information. We recommend using this for debugging purposes only and deleting the logs when finished.', 'woocommerce'), '<code>'.WC_Log_Handler_File::get_log_file_path('momo').'</code>'),
    ),
    'identity_token'        => array(
        'title'       => __('MoMo identity token', 'woocommerce'),
        'type'        => 'text',
        'description' => __('Optionally enable "Payment Data Transfer" (Profile > Profile and Settings > My Selling Tools > Website Preferences) and then copy your identity token here. This will allow payments to be verified without the need for MoMo IPN.', 'woocommerce'),
        'default'     => '',
        'desc_tip'    => true,
        'placeholder' => '',
    ),
    'invoice_prefix'        => array(
        'title'       => __('Invoice prefix', 'woocommerce'),
        'type'        => 'text',
        'description' => __('Please enter a prefix for your invoice numbers. If you use your MoMo account for multiple stores ensure this prefix is unique as MoMo will not allow orders with the same invoice number.', 'woocommerce'),
        'default'     => 'WC-',
        'desc_tip'    => true,
    ),
    'send_shipping'         => array(
        'title'       => __('Shipping details', 'woocommerce'),
        'type'        => 'checkbox',
        'label'       => __('Send shipping details to MoMo instead of billing.', 'woocommerce'),
        'description' => __('MoMo allows us to send one address. If you are using MoMo for shipping labels you may prefer to send the shipping address rather than billing. Turning this option off may prevent MoMo Seller protection from applying.', 'woocommerce'),
        'default'     => 'yes',
    ),
    'address_override'      => array(
        'title'       => __('Address override', 'woocommerce'),
        'type'        => 'checkbox',
        'label'       => __('Enable "address_override" to prevent address information from being changed.', 'woocommerce'),
        'description' => __('MoMo verifies addresses therefore this setting can cause errors (we recommend keeping it disabled).', 'woocommerce'),
        'default'     => 'no',
    ),
    'paymentaction'         => array(
        'title'       => __('Payment action', 'woocommerce'),
        'type'        => 'select',
        'class'       => 'wc-enhanced-select',
        'description' => __('Choose whether you wish to capture funds immediately or authorize payment only.', 'woocommerce'),
        'default'     => 'sale',
        'desc_tip'    => true,
        'options'     => array(
            'sale'          => __('Capture', 'woocommerce'),
            'authorization' => __('Authorize', 'woocommerce'),
        ),
    ),
    'image_url'             => array(
        'title'       => __('Image url', 'woocommerce'),
        'type'        => 'text',
        'description' => __('Optionally enter the URL to a 150x50px image displayed as your logo in the upper left corner of the MoMo checkout pages.', 'woocommerce'),
        'default'     => '',
        'desc_tip'    => true,
        'placeholder' => __('Optional', 'woocommerce'),
    ),
    'api_details'           => array(
        'title'       => __('API credentials', 'woocommerce'),
        'type'        => 'title',
        /* translators: %s: URL */
        'description' => sprintf(__('Enter your MoMo API credentials to process refunds via MoMo. Learn how to access your <a href="%s">MoMo API Credentials</a>.', 'woocommerce'), 'https://developer.momo.com/webapps/developer/docs/classic/api/apiCredentials/#create-an-api-signature'),
    ),
    'api_username'          => array(
        'title'       => __('Live API username', 'woocommerce'),
        'type'        => 'text',
        'description' => __('Get your API credentials from MoMo.', 'woocommerce'),
        'default'     => '',
        'desc_tip'    => true,
        'placeholder' => __('Optional', 'woocommerce'),
    ),
    'api_password'          => array(
        'title'       => __('Live API password', 'woocommerce'),
        'type'        => 'password',
        'description' => __('Get your API credentials from MoMo.', 'woocommerce'),
        'default'     => '',
        'desc_tip'    => true,
        'placeholder' => __('Optional', 'woocommerce'),
    ),
    'api_signature'         => array(
        'title'       => __('Live API signature', 'woocommerce'),
        'type'        => 'password',
        'description' => __('Get your API credentials from MoMo.', 'woocommerce'),
        'default'     => '',
        'desc_tip'    => true,
        'placeholder' => __('Optional', 'woocommerce'),
    ),
    'sandbox_api_username'  => array(
        'title'       => __('Sandbox API username', 'woocommerce'),
        'type'        => 'text',
        'description' => __('Get your API credentials from MoMo.', 'woocommerce'),
        'default'     => '',
        'desc_tip'    => true,
        'placeholder' => __('Optional', 'woocommerce'),
    ),
    'sandbox_api_password'  => array(
        'title'       => __('Sandbox API password', 'woocommerce'),
        'type'        => 'password',
        'description' => __('Get your API credentials from MoMo.', 'woocommerce'),
        'default'     => '',
        'desc_tip'    => true,
        'placeholder' => __('Optional', 'woocommerce'),
    ),
    'sandbox_api_signature' => array(
        'title'       => __('Sandbox API signature', 'woocommerce'),
        'type'        => 'password',
        'description' => __('Get your API credentials from MoMo.', 'woocommerce'),
        'default'     => '',
        'desc_tip'    => true,
        'placeholder' => __('Optional', 'woocommerce'),
    ),
);
