<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package WordPress
 * @subpackage Moozo
 * @since 1.0
 * @version 1.0
 */

get_header();
?>
    <div id="content" class="container site-content">
        <?php moozo_breadcrumb(); ?>
        <div id="primary" class="content-area">
            <main id="main" class="site-main" role="main">
                <section class="error-404 not-found">
                    <h1 class="page-title"><?php echo esc_html__( '404', 'moozo-elementor' ); ?></h1>
                    <h2 class="title"><?php echo esc_html__( 'Oops! That page can’t be found.', 'moozo-elementor' ); ?></h2>
                    <p class="subtitle"><?php echo esc_html__( 'Sorry, but the page you are looking for is not found. Please, make sure you have typed the current URL.', 'moozo-elementor' ); ?></p>
                    <a class="button" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_html__( 'Return to Home', 'moozo-elementor' ); ?></a>
                </section><!-- .error-404 -->
            </main><!-- #main -->
        </div><!-- #primary -->
    </div><!-- .wrap -->
<?php
get_footer();
