<?php
if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}
/**
 *
 * POST LINK
 **/
if ( !function_exists( 'moozo_post_link' ) ) {
    function moozo_post_link( $type = 'post', $id = 0 )
    {
        global $post;

        switch ( $type ) {
            case 'date':
                $archive_year  = get_the_time( 'Y' );
                $archive_month = get_the_time( 'm' );
                $archive_day   = get_the_time( 'd' );
                $permalink     = get_day_link( $archive_year, $archive_month, $archive_day );
                break;
            case 'auth':

                if ( $id == 0 ) {
                    $id = get_the_author_meta( 'ID' );
                }
                $permalink = get_author_posts_url( $id );
                break;
            default:

                if ( $id == 0 ) {
                    $id = get_the_ID();
                }
                $permalink = get_the_permalink( $id );
                break;
        }

        return apply_filters( 'ovic_loop_post_link', esc_url( $permalink ), $post );
    }
}
/**
 *
 * TEMPLATES FUNCTION
 **/
if ( !function_exists( 'moozo_post_thumbnail_simple' ) ) {
    function moozo_post_thumbnail_simple( $category = false, $effect = 'effect background-zoom' )
    {
        if ( has_post_thumbnail() ) : ?>
            <div class="post-thumb">
                <?php if ( $category ) moozo_get_term_list(); ?>
                <a href="<?php echo moozo_post_link(); ?>" class="thumb-link <?php echo esc_attr( $effect ); ?>">
                    <?php the_post_thumbnail( 'full' ); ?>
                </a>
                <?php do_action( 'moozo_post_thumbnail_inner' ); ?>
            </div>
        <?php endif;
    }
}
if ( !function_exists( 'moozo_post_thumbnail' ) ) {
    function moozo_post_thumbnail( $width, $height, $category = false, $placeholder = true, $effect = 'effect background-zoom' )
    {
        $width  = apply_filters( 'moozo_post_thumbnail_width', $width );
        $height = apply_filters( 'moozo_post_thumbnail_height', $height );
        ?>
        <div class="post-thumb">
            <?php if ( $category ) moozo_get_term_list(); ?>
            <a href="<?php echo moozo_post_link(); ?>" class="thumb-link <?php echo esc_attr( $effect ); ?>">
                <figure>
                    <?php
                    $thumb = moozo_resize_image( get_post_thumbnail_id(), $width, $height, true, true, $placeholder );
                    echo wp_specialchars_decode( $thumb['img'] );
                    ?>
                </figure>
            </a>
            <?php do_action( 'moozo_post_thumbnail_inner' ); ?>
        </div>
        <?php
    }
}
if ( !function_exists( 'moozo_post_author' ) ) {
    function moozo_post_author( $icon = false, $title = '' )
    {
        ?>
        <div class="post-meta post-author">
            <a class="author" href="<?php echo moozo_post_link( 'auth' ); ?>">
                <?php if ( $icon ): ?>
                    <span class="icon"></span>
                <?php endif; ?>
                <?php if ( !empty( $title ) ): ?>
                    <span class="title"><?php echo esc_html( $title ); ?></span>
                <?php endif; ?>
                <?php the_author(); ?>
            </a>
        </div>
        <?php
    }
}
if ( !function_exists( 'moozo_post_time_diff' ) ) {
    function moozo_post_time_diff( $icon = false )
    {
        $posted = get_the_time( 'U' );
        ?>
        <a class="posted" href="<?php echo moozo_post_link(); ?>">
            <?php if ( $icon ): ?>
                <span class="icon"></span>
            <?php endif; ?>
            <?php echo human_time_diff( $posted, current_time( 'U' ) ); ?>
        </a>
        <?php
    }
}
if ( !function_exists( 'moozo_post_viewer' ) ) {
    function moozo_post_viewer( $icon = false )
    {
        ?>
        <div class="post-viewer">
            <a class="viewer" href="<?php echo moozo_post_link(); ?>">
                <?php if ( $icon ): ?>
                    <span class="icon"></span>
                <?php endif; ?>
                <?php
                if ( function_exists( 'ovic_get_post_views' ) ) {
                    ovic_get_post_views();
                }
                echo esc_html__( ' Peoples', 'moozo-elementor' );
                ?>
            </a>
        </div>
        <?php
    }
}
if ( !function_exists( 'moozo_get_term_list' ) ) {
    function moozo_get_term_list( $taxonomy = 'category' )
    {
        echo get_the_term_list( get_the_ID(), $taxonomy,
            '<div class="cat-list ' . $taxonomy . '"><div class="inner">',
            ', ',
            '</div></div>'
        );
    }
}
if ( !function_exists( 'moozo_post_formats' ) ) {
    function moozo_post_formats()
    {
        $data      = '';
        $default   = 'standard';
        $format    = get_post_format();
        $post_meta = get_post_meta( get_the_ID(), '_custom_metabox_post_options', true );
        if ( !empty( $post_meta['post_formats'][ $format ] ) ) {
            $default = $format;
            $data    = $post_meta['post_formats'][ $format ];
        }
        moozo_get_template(
            "templates/blog/blog-formats/format-{$default}.php",
            array(
                'data' => $data,
            )
        );
    }
}
if ( !function_exists( 'moozo_post_pagination' ) ) {
    function moozo_post_pagination()
    {
        $args = array( // WPCS: XSS ok.
            'screen_reader_text' => '&nbsp;',
            'before_page_number' => '',
            'prev_text'          => esc_html__( 'Prev', 'moozo-elementor' ),
            'next_text'          => esc_html__( 'Next', 'moozo-elementor' ),
            'type'               => 'list',
        );

        $pagination = moozo_get_option( 'blog_pagination', 'pagination' );
        $blog_style = moozo_get_option( 'blog_list_style', 'standard' );
        $animate    = 'fadeInUp';
        if ( $blog_style == 'masonry' ) {
            $animate = '';
        }

        if ( function_exists( 'ovic_custom_pagination' ) ) : ?>
            <div class="pagination-wrap">
                <?php
                ovic_custom_pagination(
                    array(
                        'pagination'    => $pagination,
                        'class'         => 'button',
                        'animate'       => $animate,
                        'text_loadmore' => esc_html__( 'Load more', 'moozo-elementor' ),
                        'text_infinite' => esc_html__( 'Loading', 'moozo-elementor' ),
                    ), $args
                );
                ?>
            </div>
        <?php else: ?>
            <div class="pagination-wrap">
                <nav class="woocommerce-pagination">
                    <?php echo paginate_links( $args ); ?>
                </nav>
            </div>
        <?php endif;
    }
}
if ( !function_exists( 'moozo_result_count' ) ) {
    function moozo_result_count()
    {
        $total    = wp_count_posts()->publish;
        $current  = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
        $per_page = get_query_var( 'posts_per_page' ) ? intval( get_query_var( 'posts_per_page' ) ) : 1;
        if ( function_exists( 'is_woocommerce' ) && is_woocommerce() ) {
            $total    = wc_get_loop_prop( 'total' );
            $current  = wc_get_loop_prop( 'per_page' );
            $per_page = wc_get_loop_prop( 'current_page' );
        }
        ?>
        <p class="woocommerce-result-count">
            <?php
            if ( 1 === $total ) {
                _e( 'Showing the single result', 'moozo-elementor' );
            } elseif ( $total <= $per_page || -1 === $per_page ) {
                /* translators: %d: total results */
                printf( _n( 'Showing all %d result', 'Showing: all of %d', $total, 'moozo-elementor' ), $total );
            } else {
                $first = ( $per_page * $current ) - $per_page + 1;
                $last  = min( $total, $per_page * $current );
                /* translators: 1: first result 2: last result 3: total results */
                if ( $first == $last ) {
                    printf( _nx( 'Showing %1$d&ndash;%2$d of %3$d result', 'Showing: %1$d of %2$d', $total,
                        'with first and last result', 'moozo-elementor' ), $first, $total );
                } else {
                    printf( _nx( 'Showing %1$d&ndash;%2$d of %3$d result', 'Showing: %1$d&ndash;%2$d of %3$d', $total,
                        'with first and last result', 'moozo-elementor' ), $first, $last, $total );
                }
            }
            ?>
        </p>
        <?php
    }
}
if ( !function_exists( 'moozo_post_title' ) ) {
    function moozo_post_title( $link = true )
    {
        if ( get_the_title() ) {
            $tag = is_single() ? 'h1' : 'h2';
            if ( $link == true ) {
                echo '<' . $tag . ' class="post-title"><a href="' . moozo_post_link() . '">' . get_the_title() . '</a></' . $tag . '>';
            } else {
                echo '<' . $tag . ' class="post-title"><span>' . get_the_title() . '</span></' . $tag . '>';
            }
        }
    }
}
if ( !function_exists( 'moozo_post_readmore' ) ) {
    function moozo_post_readmore( $icon = false, $title = '' )
    {
        $text = !empty( $title ) ? $title : esc_html__( 'Read More', 'moozo-elementor' );
        ?>
        <div class="post-readmore">
            <a href="<?php echo moozo_post_link(); ?>" class="button">
                <?php if ( $icon ): ?>
                    <span class="icon"></span>
                <?php endif; ?>
                <?php echo esc_html( $text ); ?>
            </a>
        </div>
        <?php
    }
}
if ( !function_exists( 'moozo_post_excerpt' ) ) {
    function moozo_post_excerpt( $count = 35 )
    {
        ?>
        <div class="post-excerpt">
            <?php
            if ( $count == null ) {
                echo apply_filters( 'the_excerpt', get_the_excerpt() );
            } else {
                echo wp_trim_words( apply_filters( 'the_excerpt', get_the_excerpt() ), $count,
                    esc_html__( '...', 'moozo-elementor' ) );
            }
            ?>
        </div>
        <?php
    }
}
if ( !function_exists( 'moozo_post_content' ) ) {
    function moozo_post_content()
    {
        if ( !is_search() ):
            ?>
            <div class="post-content">
                <?php
                /* translators: %s: Name of current post */
                the_content( sprintf(
                        esc_html__( 'Continue reading %s', 'moozo-elementor' ),
                        the_title( '<span class="screen-reader-text">', '</span>', false )
                    )
                );
                wp_link_pages( array(
                        'before'      => '<div class="post-pagination"><span class="title">' . esc_html__( 'Pages:',
                                'moozo-elementor' ) . '</span>',
                        'after'       => '</div>',
                        'link_before' => '<span>',
                        'link_after'  => '</span>',
                    )
                );
                ?>
            </div>
        <?php
        endif;
    }
}
if ( !function_exists( 'moozo_post_date' ) ) {
    function moozo_post_date( $icon = false, $format = '' )
    {
        ?>
        <div class="post-meta post-date">
            <a href="<?php echo moozo_post_link( 'date' ); ?>">
                <?php if ( $icon ): ?>
                    <span class="icon"></span>
                <?php endif; ?>
                <?php
                if ( !empty( $format ) ) {
                    echo get_the_date( $format );
                } else {
                    echo get_the_date();
                }
                ?>
            </a>
        </div>
        <?php
    }
}
if ( !function_exists( 'moozo_post_share' ) ) {
    function moozo_post_share()
    {
        $share = moozo_get_option( 'enable_share_post' );
        if ( $share == 1 ): ?>
            <div class="post-share">
                <?php moozo_share_social( get_the_ID() ); ?>
            </div>
        <?php endif;
    }
}
if ( !function_exists( 'moozo_post_comment' ) ) {
    function moozo_post_comment( $icon = false )
    {
        ?>
        <div class="post-meta post-comment">
            <a href="<?php echo moozo_post_link(); ?>#comments" class="comment">
                <?php if ( $icon ): ?>
                    <span class="icon"></span>
                <?php endif; ?>
                <?php comments_number(
                    esc_html__( '0 Comments', 'moozo' ),
                    esc_html__( '1 Comment', 'moozo' ),
                    esc_html__( '% Comments', 'moozo' )
                ); ?>
            </a>
        </div>
        <?
    }
}
if ( !function_exists( 'moozo_post_meta' ) ) {
    function moozo_post_meta( $date = false )
    {
        $share = moozo_get_option( 'enable_share_post' );
        ?>
        <div class="post-meta">
            <?php moozo_post_author(); ?>
            <?php if ( $date == true ) : ?>
                <div class="post-date">
                    <a href="<?php echo moozo_post_link( 'date' ); ?>">
                        <span class="icon fa fa-calendar"></span>
                        <?php echo get_the_date( 'd M' ); ?>
                    </a>
                </div>
            <?php endif; ?>
            <div class="post-comment">
                <a href="<?php echo moozo_post_link(); ?>#comments" class="comment">
                    <span class="icon fa fa-comment-o"></span>
                    (<?php comments_number( '0', '1', '%' ); ?>)
                </a>
            </div>
            <?php if ( $share == 1 ): ?>
                <div class="share-post">
                    <a href="#" class="toggle">
                        <span class="icon fa fa-share-alt"></span>
                    </a>
                    <?php moozo_share_social( get_the_ID() ); ?>
                </div>
            <?php endif; ?>
        </div>
        <?php
    }
}
if ( !function_exists( 'moozo_post_related' ) ) {
    function moozo_post_related()
    {
        get_template_part( 'templates-parts/blog', 'related' );
    }
}
if ( !function_exists( 'moozo_post_sticky' ) ) {
    function moozo_post_sticky()
    {
        get_template_part( 'templates-parts/blog', 'sticky' );
    }
}
if ( !function_exists( 'moozo_comment_form_args' ) ) {
    function moozo_comment_form_args()
    {
        return array(
            'wraper_start' => '<div class="row">',
            'author'       => '<p class="comment-form-author col-sm-6"><input placeholder="' . esc_attr__( 'Name', 'moozo-elementor' ) . '" type="text" name="author" id="author" required="required" /></p>',
            'surname'      => '<p class="comment-form-author col-sm-6"><input placeholder="' . esc_attr__( 'Surname', 'moozo-elementor' ) . '" type="text" name="surname" id="surname" /></p>',
            'email'        => '<p class="comment-form-email col-sm-6"><input placeholder="' . esc_attr__( 'Email', 'moozo-elementor' ) . '" type="text" name="email" id="email" aria-describedby="email-notes" required="required" /></p>',
            'phone'        => '<p class="comment-form-phone col-sm-6"><input placeholder="' . esc_attr__( 'Phone', 'moozo-elementor' ) . '" type="text" name="phone" id="phone" /></p>',
            'wraper_end'   => '</div>',
        );
    }
}
if ( !function_exists( 'moozo_comment_form_field' ) ) {
    function moozo_comment_form_field( $text = '' )
    {
        if ( empty( $text ) ) $text = esc_attr__( 'Comment ...', 'moozo-elementor' );
        return '<p class="comment-form-comment"><textarea placeholder="' . $text . '" class="input-form" id="comment" name="comment" cols="45" rows="8" aria-required="true">' . '</textarea></p>';
    }
}
if ( !function_exists( 'moozo_callback_comment' ) ) {
    /**
     * Ocolus comment template
     *
     * @param  array $comment the comment array.
     * @param  array $args the comment args.
     * @param  int $depth the comment depth.
     *
     * @since 1.0.0
     */
    function moozo_callback_comment( $comment, $args, $depth )
    {
        $tag       = ( 'div' === $args['style'] ) ? 'div' : 'li';
        $commenter = wp_get_current_commenter();
        if ( $commenter['comment_author_email'] ) {
            $moderation_note = esc_html__( 'Your comment is awaiting moderation.', 'moozo-elementor' );
        } else {
            $moderation_note = esc_html__( 'Your comment is awaiting moderation. This is a preview, your comment will be visible after it has been approved.',
                'moozo-elementor' );
        }
        ?>
        <<?php echo wp_specialchars_decode( $tag ); ?> id="comment-<?php comment_ID(); ?>" <?php comment_class( empty( $args['has_children'] ) ? 'parent' : '', $comment ); ?>>
        <div id="div-comment-<?php comment_ID(); ?>" class="comment-body">
            <div class="comment-text">
                <?php comment_text(); ?>
            </div><!-- .comment-content -->
            <div class="comment-info">
                <?php if ( 0 != $args['avatar_size'] ): ?>
                    <div class="comment-avatar">
                        <figure><?php echo get_avatar( $comment, $args['avatar_size'] ); ?></figure>
                    </div>
                <?php endif; ?>
                <div class="comment-meta">
                    <div class="comment-author vcard">
                        <?php
                        /* translators: %s: comment author link */
                        printf( '<b class="fn">%s</b>', get_comment_author_link( $comment ) );
                        ?>
                    </div>
                    <div class="comment-date">
                        <a href="<?php echo esc_url( get_comment_link( $comment, $args ) ); ?>">
                            <time datetime="<?php comment_time( 'c' ); ?>">
                                <?php
                                /* translators: 1: comment date */
                                printf( esc_html__( '%1$s', 'moozo-elementor' ), get_comment_date( '', $comment ) );
                                ?>
                            </time>
                        </a>
                    </div>
                    <?php
                    edit_comment_link(
                        esc_html__( 'Edit', 'moozo-elementor' ),
                        '<span class="edit-link">',
                        '</span>'
                    );
                    comment_reply_link(
                        array_merge( $args,
                            array(
                                'add_below' => 'div-comment',
                                'depth'     => $depth,
                                'max_depth' => $args['max_depth'],
                                'before'    => '<div class="reply">',
                                'after'     => '</div>',
                            )
                        )
                    );
                    ?>
                </div><!-- .comment-meta -->
                <?php if ( '0' == $comment->comment_approved ) : ?>
                    <em class="comment-awaiting-moderation"><?php echo esc_html( $moderation_note ); ?></em>
                <?php endif; ?>
            </div>
        </div><!-- .comment-body -->
        <?php
    }
}