<?php if ( !defined( 'ABSPATH' ) ) {
    die;
} // Cannot access pages directly.

if ( moozo_is_mobile() ) {
    include_once dirname( __FILE__ ) . '/function-mobile.php';
}

add_filter( 'ovic_get_api_libary_elementor', function ( $url, $api, $info ) {
    return str_replace(
        '{THEME_URI}/libary-elementor/',
        'https://moozo.kutethemes.net/moozo-elementor/',
        $api
    );
}, 10, 3 );

add_filter( 'ovic_menu_toggle_mobile', '__return_false' );
add_filter( 'ovic_menu_locations_mobile', 'moozo_extend_mobile_menu', 10, 2 );
add_filter( 'ovic_override_footer_template', 'moozo_footer_template' );
add_filter( 'elementor/icons_manager/native', 'moozo_elementor_icons' );
add_action( 'import_sample_data_after_install_sample_data', 'moozo_after_install_sample_data' );
add_action( 'moozo_before_mobile_header', 'moozo_mobile_menu_top', 10 );
add_action( 'moozo_after_mobile_header', 'moozo_mobile_menu_bottom', 10 );
add_action( 'dynamic_sidebar_before', 'moozo_dynamic_sidebar_before', 10, 2 );
add_action( 'dynamic_sidebar_after', 'moozo_dynamic_sidebar_after', 10, 2 );
add_action( 'dgwt/wcas/search_query/args', 'moozo_search_query_args' );
/**
 *
 * ajax search query
 */
if ( !function_exists( 'moozo_search_query_args' ) ) {
    function moozo_search_query_args( $args )
    {
        if ( !empty( $_REQUEST['product_cat'] ) ) {

            $product_cat = sanitize_text_field( $_REQUEST['product_cat'] );

            $args['tax_query'][] = array(
                'taxonomy' => 'product_cat',
                'field'    => 'slug',
                'terms'    => array( $product_cat ),
            );
        }

        return $args;
    }
}
/**
 *
 * dynamic sidebar
 */
if ( !function_exists( 'moozo_dynamic_sidebar_before' ) ) {
    function moozo_dynamic_sidebar_before()
    {
        if ( !is_admin() ) {
            if ( moozo_is_mobile() ) :?>
                <div class="sidebar-head">
                    <span class="title"><?php echo esc_html__( 'Sidebar', 'moozo-elementor' ); ?></span>
                    <a href="#" class="close-sidebar"></a>
                </div>
            <?php endif;
            echo '<div class="sidebar-inner">';
        }
    }
}
if ( !function_exists( 'moozo_dynamic_sidebar_after' ) ) {
    function moozo_dynamic_sidebar_after()
    {
        if ( !is_admin() ) {
            echo '</div>';
        }
    }
}
/**
 *
 * TEMPLATE HEADER
 */
if ( !function_exists( 'moozo_header_template' ) ) {
    function moozo_header_template()
    {
        if ( moozo_is_mobile() ) {
            moozo_mobile_template();
        } else {
            $sticky_menu = moozo_get_option( 'sticky_menu', 'none' );
            get_template_part( 'templates-parts/header', 'banner' );
            get_template_part( 'templates/header/header', moozo_get_header() );
            if ( $sticky_menu == 'template' ) {
                get_template_part( 'templates-parts/header', 'sticky' );
            }
            if ( !class_exists( 'Ovic_Megamenu_Settings' ) ) {
                moozo_mobile_menu( 'primary' );
            }
        }
    }
}
if ( !function_exists( 'moozo_footer_template' ) ) {
    function moozo_footer_template()
    {
        return moozo_get_footer();
    }
}
if ( !function_exists( 'moozo_extend_mobile_menu' ) ) {
    function moozo_extend_mobile_menu( $menus, $locations )
    {

        $vertical_menu = apply_filters( 'moozo_extend_mobile_menu_vertical', moozo_theme_option_meta(
            '_custom_metabox_theme_options',
            'vertical_menu',
            'metabox_vertical_menu'
        ) );
        $primary_menu  = moozo_theme_option_meta(
            '_custom_metabox_theme_options',
            null,
            'metabox_primary_menu'
        );
        if ( !empty( $primary_menu ) ) {
            $term = get_term_by( 'slug', $primary_menu, 'nav_menu' );
            if ( !is_wp_error( $term ) && !empty( $term ) ) {
                $menus = array( $primary_menu );
            }
        }
        if ( empty( $menus ) && !empty( $locations['primary'] ) ) {
            $mobile_menu = wp_get_nav_menu_object( $locations['primary'] );
            $menus[]     = $mobile_menu->slug;
        }
        if ( !empty( $primary_second ) ) {
            $menus[] = $primary_second;
        }
        if ( !empty( $vertical_menu ) ) {
            $menus[] = $vertical_menu;
        }

        return $menus;
    }
}
/**
 *
 * PRIMARY MENU
 */
if ( !function_exists( 'moozo_primary_menu' ) ) {
    function moozo_primary_menu( $layout = 'horizontal' )
    {
        $enable_metabox = moozo_theme_option_meta(
            '_custom_metabox_theme_options',
            null,
            "enable_metabox_options"
        );
        $primary_menu   = '';
        if ( $enable_metabox == 1 ) {
            $primary_menu = moozo_theme_option_meta(
                '_custom_metabox_theme_options',
                null,
                "metabox_primary_menu"
            );
        }
        if ( !empty( $primary_menu ) ) {
            $term = get_term_by( 'slug', $primary_menu, 'nav_menu' );
            if ( !is_wp_error( $term ) && !empty( $term ) ) {
                wp_nav_menu( array(
                        'menu'            => $primary_menu,
                        'theme_location'  => $primary_menu,
                        'depth'           => 3,
                        'container'       => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'menu_class'      => 'moozo-nav main-menu ' . $layout . '-menu',
                        'megamenu_layout' => $layout,
                    )
                );
            }
        } else {
            if ( has_nav_menu( 'primary' ) ) {
                wp_nav_menu( array(
                        'menu'            => 'primary',
                        'theme_location'  => 'primary',
                        'depth'           => 3,
                        'container'       => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'menu_class'      => 'moozo-nav main-menu ' . $layout . '-menu',
                        'megamenu_layout' => $layout,
                    )
                );
            }
        }
    }
}
if ( !function_exists( 'moozo_header_menu_bar' ) ) {
    function moozo_header_menu_bar()
    {
        ?>
        <div class="mobile-block block-menu-bar">
            <a href="javascript:void(0)" class="menu-bar menu-toggle">
                <span class="icon main-icon-menu"></span>
                <span class="text"><?php echo esc_html__( 'Menu', 'moozo-elementor' ); ?></span>
            </a>
        </div>
        <?php
    }
}
/**
 *
 * VERTICAL MENU
 */
if ( !function_exists( 'moozo_vertical_menu_menu' ) ) {
    function moozo_vertical_menu_menu()
    {
        get_template_part( 'templates-parts/header', 'vertical' );
    }
}
/**
 *
 * HEADER SUB MENU
 */
if ( !function_exists( 'moozo_header_submenu' ) ) {
    function moozo_header_submenu( $menu_location, $depth = 2 )
    {
        $header_menu = moozo_theme_option_meta(
            '_custom_metabox_theme_options',
            $menu_location,
            "metabox_{$menu_location}"
        );
        if ( !empty( $header_menu ) ) {
            do_action( "moozo_before_header_menu_{$header_menu}", $header_menu );
            wp_nav_menu( array(
                    'menu'           => $header_menu,
                    'theme_location' => $header_menu,
                    'link_before'    => '<span class="text">',
                    'link_after'     => '</span>',
                    'depth'          => $depth,
                    'menu_class'     => 'ovic-menu header-submenu ' . $menu_location,
                )
            );
            do_action( "moozo_after_header_menu_{$header_menu}", $header_menu );
        }
    }
}
/**
 *
 * HEADER SEARCH
 */
if ( !function_exists( 'moozo_header_banner' ) ) {
    function moozo_header_banner()
    {
        get_template_part( 'templates-parts/header', 'banner' );
    }
}
/**
 *
 * HEADER MESSAGE
 */
if ( !function_exists( 'moozo_header_message' ) ) {
    function moozo_header_message()
    {
        get_template_part( 'templates-parts/header', 'message' );
    }
}
/**
 *
 * HEADER SEARCH
 */
if ( !function_exists( 'moozo_header_social' ) ) {
    function moozo_header_social()
    {
        get_template_part( 'templates-parts/header', 'social' );
    }
}
/**
 *
 * HEADER SEARCH
 */
if ( !function_exists( 'moozo_header_search' ) ) {
    function moozo_header_search( $category = false, $text = '' )
    {
        echo '<div class="block-search">';
        moozo_get_template(
            "templates-parts/header-search.php",
            array(
                'category' => $category,
                'text'     => $text,
            )
        );
        echo '</div>';
    }
}
/**
 *
 * HEADER SEARCH POPUP
 */
if ( !function_exists( 'moozo_header_search_popup' ) ) {
    function moozo_header_search_popup( $category = false, $text = '' )
    {
        ?>
        <div class="block-search moozo-dropdown">
            <a data-moozo="moozo-dropdown" class="woo-search-link" href="javascript:void(0)">
                <span class="icon main-icon-search1"></span>
                <span class="text"><?php echo esc_html__( 'Search', 'moozo-elementor' ); ?></span>
            </a>
            <?php
            moozo_get_template(
                "templates-parts/header-search.php",
                array(
                    'category' => $category,
                    'text'     => $text,
                )
            );
            ?>
        </div>
        <?php
    }
}
/**
 *
 * HEADER ACCOUNT MENU
 */
if ( !function_exists( 'moozo_header_user' ) ) {
    function moozo_header_user( $text = '' )
    {
        moozo_get_template(
            "templates-parts/header-user.php",
            array(
                'text' => $text,
            )
        );
    }
}
/**
 *
 * CUSTOM MOBILE MENU
 */
if ( !function_exists( 'moozo_before_mobile_menu' ) ) {
    function moozo_before_mobile_menu( $menu_locations, $data_menus )
    {
        moozo_get_template(
            "templates-parts/mobile-header.php",
            array(
                'menu_locations' => $menu_locations,
                'data_menus'     => $data_menus,
            )
        );
    }

    add_action( 'ovic_before_html_mobile_menu', 'moozo_before_mobile_menu', 10, 2 );
}
if ( !function_exists( 'moozo_after_mobile_menu' ) ) {
    function moozo_after_mobile_menu( $menu_locations, $data_menus )
    {
        moozo_get_template(
            "templates-parts/mobile-footer.php",
            array(
                'menu_locations' => $menu_locations,
                'data_menus'     => $data_menus,
            )
        );
    }

    add_action( 'ovic_after_html_mobile_menu', 'moozo_after_mobile_menu', 10, 2 );
}
/**
 *
 * MEGAMENU ICON
 */
add_filter( 'ovic_field_icon_add_icons', 'moozo_theme_options_icons' );
if ( !function_exists( 'moozo_theme_options_icons' ) ) {
    function moozo_theme_options_icons( $icon )
    {
        moozo_get_template( "templates-parts/icon-options.php" );

        return moozo_get_icon_options( $icon );
    }
}
/**
 *
 * MEGAMENU ICON
 */
add_filter( 'ovic_menu_icons_setting', 'moozo_megamenu_options_icons' );
if ( !function_exists( 'moozo_megamenu_options_icons' ) ) {
    function moozo_megamenu_options_icons()
    {
        moozo_get_template( "templates-parts/icon-megamenu.php" );

        return moozo_get_icon_megamenu();
    }
}
if ( !function_exists( 'moozo_elementor_icons' ) ) {
    function moozo_elementor_icons( $tabs )
    {
        $tabs['main-icon'] = [
            'name'          => 'main-icon',
            'label'         => esc_html__( 'Theme Icons', 'moozo-elementor' ),
            'url'           => get_theme_file_uri( '/assets/vendor/main-icon/style.min.css' ),
            'enqueue'       => [],
            'prefix'        => '',
            'displayPrefix' => '',
            'labelIcon'     => 'fab fa-font-awesome-alt',
            'ver'           => '1.0.0',
            'fetchJson'     => get_theme_file_uri( '/assets/json/main-icon.json' ),
            'native'        => true,
        ];

        return $tabs;
    }
}
if ( !function_exists( 'moozo_after_install_sample_data' ) ) {
    function moozo_after_install_sample_data()
    {
        $cpt_support   = get_option( 'elementor_cpt_support', [ 'page', 'post' ] );
        $cpt_support[] = 'ovic_menu';
        $cpt_support[] = 'ovic_footer';

        update_option( 'elementor_cpt_support', $cpt_support );
        update_option( 'elementor_disable_color_schemes', 'yes' );
        update_option( 'elementor_disable_typography_schemes', 'yes' );
        update_option( 'elementor_load_fa4_shim', 'yes' );

        if ( class_exists( 'Elementor\Plugin' ) ) {
            $manager = new Elementor\Core\Files\Manager();
            $manager->clear_cache();
        }
    }
}