<?php
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
if ( !function_exists( 'moozo_enqueue_inline_css' ) ) {
    function moozo_enqueue_inline_css()
    {
        $css                = html_entity_decode( moozo_get_option( 'ace_style', '' ) );
        $main_bora          = moozo_get_option( 'main_bora', 4 );
        $main_fw            = moozo_get_option( 'main_fw', 500 );
        $main_tt            = moozo_get_option( 'main_tt', 'none' );
        $sidebar_width      = moozo_get_option( 'sidebar_width', 270 );
        $sidebar_space      = moozo_get_option( 'sidebar_space', 30 );
        $shop_sidebar_width = moozo_get_option( 'shop_sidebar_width', '' );
        $shop_sidebar_space = moozo_get_option( 'shop_sidebar_space', '' );
        $main_color         = moozo_theme_option_meta(
            '_custom_metabox_theme_options',
            'main_color',
            'metabox_main_color',
            '#C90000'
        );
        $main_color_2       = moozo_theme_option_meta(
            '_custom_metabox_theme_options',
            'main_color',
            'metabox_main_color',
            '#0046c3'
        );
        $container          = moozo_theme_option_meta(
            '_custom_metabox_theme_options',
            'main_container',
            'metabox_main_container',
            '1250'
        );
        $visible_item       = moozo_theme_option_meta(
            '_custom_metabox_theme_options',
            'vertical_visible_item'
        );

        $css .= 'body{';
        $css .= '--main-color:' . $main_color . ';';
        $css .= '--main-color-2:' . $main_color_2 . ';';
        if ( $main_bora != 4 )
            $css .= '--main-bora:' . $main_bora . 'px;';
        if ( $main_fw != 500 )
            $css .= '--main-h-fw:' . $main_fw . ';';
        if ( $main_tt != 'none' )
            $css .= '--main-h-tt:' . $main_tt . ';';
        if ( $sidebar_width != 270 )
            $css .= '--sidebar-width:' . $sidebar_width . 'px;';
        if ( $sidebar_space != 30 )
            $css .= '--sidebar-space:' . $sidebar_space . 'px;';
        if ( $shop_sidebar_width != '' ) {
            $css .= '--shop-sidebar-width:' . $shop_sidebar_width . 'px;';
        } else {
            $css .= '--shop-sidebar-width:' . $sidebar_width . 'px;';
        }
        if ( $shop_sidebar_space != '' ) {
            $css .= '--shop-sidebar-space:' . $shop_sidebar_space . 'px;';
        } else {
            $css .= '--shop-sidebar-space:' . $sidebar_space . 'px;';
        }
        $css .= '}';
        if ( !empty( $container ) && $container != 1140 ) {
            $container_padding = $container + 30;
            $media             = $container_padding < 1200 ? 1200 : ( $container_padding + 30 );
            $css               .= '
            @media (min-width: ' . $media . 'px){
                body{
                    --main-container:' . $container . 'px;
                }
                .elementor-section.elementor-section-boxed:not(.elementor-has-width) > .elementor-container{
                    width:' . $container . 'px;
                }
                .elementor-section-stretched.elementor-section-full_width .elementor-section.elementor-section-boxed:not(.elementor-has-width) > .elementor-container,
                .elementor-section-stretched.elementor-section-boxed:not(.elementor-has-width) > .elementor-container,
                .header .megamenu > .elementor > .elementor-inner,
                .site > .elementor > .elementor-inner,
                .container{
                    width:' . $container_padding . 'px;
                }
                body.wcfm-store-page .site #main{
                    width:' . $container_padding . 'px !important;
                }
            }
            ';
        }
        if ( !empty( $visible_item ) ) {
            $css .= '
            .box-nav-vertical .vertical-menu > .menu-item:nth-child(n+' . ( $visible_item + 1 ) . '){
                display:none;
            }';
        }

        $css = preg_replace( '/\s+/', ' ', $css );

        wp_add_inline_style( 'moozo-main',
            apply_filters( 'moozo_custom_inline_css', $css, $main_color, $container )
        );
    }

    add_action( 'wp_enqueue_scripts', 'moozo_enqueue_inline_css', 30 );
}