<?php if ( !defined( 'ABSPATH' ) ) {
    die;
} // Cannot access pages directly.
/*==========================================================================
METABOX BOX OPTIONS
===========================================================================*/
if ( !function_exists( 'moozo_metabox_options' ) && class_exists( 'OVIC_Metabox' ) ) {
    function moozo_metabox_options()
    {
        $vertical_menu = 'tools_o-01,tools_o-02,tools_o-03,fashion-modern-01,fashion-modern-04';
        $sections      = array();
        // -----------------------------------------
        // Page Side Meta box Options              -
        // -----------------------------------------
        $sections[] = array(
            'id'             => '_custom_page_side_options',
            'title'          => esc_html__( 'Custom Page Side Options', 'moozo-elementor' ),
            'post_type'      => 'page',
            'context'        => 'side',
            'priority'       => 'high',
            'page_templates' => 'default',
            'sections'       => array(
                array(
                    'name'   => 'page_option',
                    'fields' => array(
                        array(
                            'id'    => 'page_breadcrumbs',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Hide Page Breadcrumbs', 'moozo-elementor' ),
                            'desc'  => esc_html__( 'for Default Template', 'moozo-elementor' ),
                        ),
                        array(
                            'id'    => 'page_title',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Hide Page Title', 'moozo-elementor' ),
                            'desc'  => esc_html__( 'for Default Template', 'moozo-elementor' ),
                        ),
                        array(
                            'id'         => 'sidebar_page_layout',
                            'type'       => 'image_select',
                            'title'      => esc_html__( 'Single Page Sidebar Position', 'moozo-elementor' ),
                            'desc'       => esc_html__( 'Select sidebar position on Page.', 'moozo-elementor' ),
                            'options'    => array(
                                'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
                                'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
                                'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
                            ),
                            'default'    => 'left',
                            'attributes' => array(
                                'data-depend-id' => 'sidebar_page_layout',
                            ),
                        ),
                        array(
                            'id'         => 'page_sidebar',
                            'type'       => 'select',
                            'title'      => esc_html__( 'Page Sidebar', 'moozo-elementor' ),
                            'options'    => 'sidebars',
                            'dependency' => array( 'sidebar_page_layout', '!=', 'full' ),
                        ),
                        array(
                            'id'    => 'page_extra_class',
                            'type'  => 'text',
                            'title' => esc_html__( 'Extra Class', 'moozo-elementor' ),
                        ),
                    ),
                ),
            ),
        );
        // -----------------------------------------
        // Page Meta box Options                   -
        // -----------------------------------------
        $sections[] = array(
            'id'        => '_custom_metabox_theme_options',
            'title'     => esc_html__( 'Custom Theme Options', 'moozo-elementor' ),
            'post_type' => 'page',
            'context'   => 'normal',
            'priority'  => 'high',
            'sections'  => array(
                'options' => array(
                    'name'   => 'options',
                    'title'  => esc_html__( 'General', 'moozo-elementor' ),
                    'icon'   => 'fa fa-wordpress',
                    'fields' => array(
                        array(
                            'id'    => 'enable_metabox_options',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Metabox Options', 'moozo-elementor' ),
                            'desc'  => esc_html__( 'If this option enable then this page will get setting in here, else this page will get setting in Theme Options', 'moozo-elementor' ),
                        ),
                        array(
                            'id'    => 'metabox_logo',
                            'type'  => 'image',
                            'title' => esc_html__( 'Logo', 'moozo-elementor' ),
                            'desc'  => esc_html__( 'Setting Logo For Site', 'moozo-elementor' ),
                        ),
                        array(
                            'id'      => 'metabox_main_skin',
                            'type'    => 'select',
                            'title'   => esc_html__( 'Main Skin', 'moozo-elementor' ),
                            'options' => array(
                                'accessories'    => esc_html__( 'Accessories', 'moozo-elementor' ),
                                'carparts'       => esc_html__( 'Carparts', 'moozo-elementor' ),
                                'cosmetics'      => esc_html__( 'Cosmetics', 'moozo-elementor' ),
                                'courses'        => esc_html__( 'Courses', 'moozo-elementor' ),
                                'fashion'        => esc_html__( 'Fashion', 'moozo-elementor' ),
                                'fashion-clean'  => esc_html__( 'Fashion Clean', 'moozo-elementor' ),
                                'fashion-modern' => esc_html__( 'Fashion Modern', 'moozo-elementor' ),
                                'fashion-simple' => esc_html__( 'Fashion Simple', 'moozo-elementor' ),
                                'furniture'      => esc_html__( 'Furniture', 'moozo-elementor' ),
                                'glasses'        => esc_html__( 'Glasses', 'moozo-elementor' ),
                                'jewelry'        => esc_html__( 'Jewelry', 'moozo-elementor' ),
                                'market'         => esc_html__( 'Market', 'moozo-elementor' ),
                                'market-gray'    => esc_html__( 'Market Gray', 'moozo-elementor' ),
                                'market-light'   => esc_html__( 'Market Light', 'moozo-elementor' ),
                                'medical'        => esc_html__( 'Medical', 'moozo-elementor' ),
                                'organic'        => esc_html__( 'Organic', 'moozo-elementor' ),
                                'tools'          => esc_html__( 'Tools', 'moozo-elementor' ),
                                'tools-orange'   => esc_html__( 'Tools Orange', 'moozo-elementor' ),
                            ),
                            'default' => 'tools',
                        ),
                        array(
                            'id'      => 'metabox_main_container',
                            'type'    => 'slider',
                            'title'   => esc_html__( 'Main Container', 'moozo-elementor' ),
                            'min'     => 1140,
                            'max'     => 1920,
                            'step'    => 10,
                            'unit'    => esc_html__( 'px', 'moozo-elementor' ),
                            'default' => 1250,
                        ),
                        array(
                            'id'      => 'metabox_main_color',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#C90000',
                            'title'   => esc_html__( 'Main Color', 'moozo-elementor' ),
                        ),
                        array(
                            'id'      => 'metabox_main_color_2',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#0046c3',
                            'title'   => esc_html__( 'Main Color 2', 'moozo-elementor' ),
                        ),
                        array(
                            'id'             => 'body_typography',
                            'type'           => 'typography',
                            'title'          => esc_html__( 'Typography of Body', 'moozo-elementor' ),
                            'font_family'    => true,
                            'font_weight'    => true,
                            'font_style'     => true,
                            'subset'         => true,
                            'text_align'     => true,
                            'text_transform' => true,
                            'font_size'      => true,
                            'line_height'    => true,
                            'letter_spacing' => true,
                            'extra_styles'   => true,
                            'color'          => true,
                            'output'         => 'body',
                        ),
                    ),
                ),
                'header'  => array(
                    'name'   => 'header',
                    'title'  => esc_html__( 'Header', 'moozo-elementor' ),
                    'icon'   => 'fa fa-folder-open-o',
                    'fields' => array(
                        array(
                            'id'         => 'metabox_header_template',
                            'type'       => 'select_preview',
                            'options'    => moozo_file_options( '/templates/header/', 'header' ),
                            'default'    => 'tools-01',
                            'attributes' => array(
                                'data-depend-id' => 'metabox_header_template',
                            ),
                        ),
                        array(
                            'id'          => 'metabox_primary_menu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Primary Menu', 'moozo-elementor' ),
                            'desc'        => esc_html__( 'default is Display location on Menu panel: "Primary Menu"', 'moozo-elementor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'moozo-elementor' ),
                        ),
                        array(
                            'id'          => 'metabox_header_banner',
                            'type'        => 'select',
                            'options'     => 'page',
                            'chosen'      => true,
                            'ajax'        => true,
                            'placeholder' => esc_html__( 'None', 'moozo-elementor' ),
                            'title'       => esc_html__( 'Header Banner', 'moozo-elementor' ),
                            'desc'        => esc_html__( 'Get banner on header from page builder', 'moozo-elementor' ),
                        ),
                        array(
                            'id'    => 'metabox_header_message',
                            'type'  => 'textarea',
                            'title' => esc_html__( 'Header Message', 'moozo-elementor' ),
                        ),
                        array(
                            'id'          => 'metabox_extend_menu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Extend Menu', 'moozo-elementor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'moozo-elementor' ),
                        ),
                        array(
                            'id'          => 'metabox_language_menu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Language Menu', 'moozo-elementor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'moozo-elementor' ),
                        ),
                        array(
                            'id'    => 'metabox_social_menu',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Social Menu', 'moozo-elementor' ),
                        ),
                        array(
                            'id'          => 'metabox_vertical_menu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Vertical Menu', 'moozo-elementor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'moozo-elementor' ),
                            'dependency'  => array( 'metabox_header_template', 'any', $vertical_menu, true ),
                        ),
                        array(
                            'id'         => 'metabox_vertical_title',
                            'type'       => 'text',
                            'title'      => esc_html__( 'Vertical Menu Title', 'moozo-elementor' ),
                            'default'    => esc_html__( 'Shop by Category', 'moozo-elementor' ),
                            'dependency' => array( 'metabox_header_template', 'any', $vertical_menu, true ),
                        ),
                        array(
                            'id'         => 'metabox_vertical_height',
                            'type'       => 'spinner',
                            'title'      => esc_html__( 'Vertical Menu Height', 'moozo-elementor' ),
                            'dependency' => array( 'metabox_header_template', 'any', $vertical_menu, true ),
                        ),
                    ),
                ),
                'footer'  => array(
                    'name'   => 'footer',
                    'title'  => esc_html__( 'Footer', 'moozo-elementor' ),
                    'icon'   => 'fa fa-folder-open-o',
                    'fields' => array(
                        array(
                            'id'      => 'metabox_footer_template',
                            'type'    => 'select_preview',
                            'default' => 'tools-01',
                            'options' => moozo_footer_preview(),
                        ),
                    ),
                ),
            ),
        );
        // -----------------------------------------
        // Post Meta box Options                   -
        // -----------------------------------------
        $sections[] = array(
            'id'        => '_custom_metabox_post_options',
            'title'     => esc_html__( 'Post Meta', 'moozo-elementor' ),
            'post_type' => 'post',
            'context'   => 'normal',
            'priority'  => 'high',
            'sections'  => array(
                array(
                    'name'   => 'post_options',
                    'icon'   => 'fa fa-picture-o',
                    'fields' => array(
                        array(
                            'id'    => 'post_formats',
                            'type'  => 'tabbed',
                            'title' => esc_html__( 'Post formats', 'moozo-elementor' ),
                            'desc'  => esc_html__( 'The data post formats', 'moozo-elementor' ),
                            'tabs'  => array(
                                array(
                                    'title'  => esc_html__( 'Quote', 'moozo-elementor' ),
                                    'fields' => array(
                                        array(
                                            'id'         => 'quote',
                                            'type'       => 'text',
                                            'title'      => esc_html__( 'Quote Text', 'moozo-elementor' ),
                                            'attributes' => array(
                                                'style' => 'width:100%',
                                            ),
                                        ),
                                    ),
                                ),
                                array(
                                    'title'  => esc_html__( 'Gallery', 'moozo-elementor' ),
                                    'fields' => array(
                                        array(
                                            'id'    => 'gallery',
                                            'type'  => 'gallery',
                                            'title' => esc_html__( 'Gallery source', 'moozo-elementor' ),
                                        ),
                                    ),
                                ),
                                array(
                                    'title'  => esc_html__( 'Video', 'moozo-elementor' ),
                                    'fields' => array(
                                        array(
                                            'id'      => 'video',
                                            'type'    => 'upload',
                                            'library' => 'video',
                                            'title'   => esc_html__( 'Video source', 'moozo-elementor' ),
                                        ),
                                    ),
                                ),
                                array(
                                    'title'  => esc_html__( 'Audio', 'moozo-elementor' ),
                                    'fields' => array(
                                        array(
                                            'id'      => 'audio',
                                            'type'    => 'upload',
                                            'title'   => esc_html__( 'Audio source', 'moozo-elementor' ),
                                            'library' => 'audio',
                                        ),
                                    ),
                                ),
                            ),
                        ),
                    ),
                ),

            ),
        );
        // -----------------------------------------
        // Product Meta box Options                -
        // -----------------------------------------
        if ( class_exists( 'WooCommerce' ) ) {
            $sections[] = array(
                'id'        => '_custom_metabox_product_options',
                'title'     => esc_html__( 'Custom Product Options', 'moozo-elementor' ),
                'post_type' => 'product',
                'context'   => 'side',
                'priority'  => 'high',
                'sections'  => array(
                    array(
                        'name'   => 'product_option',
                        'fields' => array(
                            array(
                                'id'    => 'poster',
                                'type'  => 'image',
                                'title' => esc_html__( 'Poster Video', 'moozo-elementor' ),
                            ),
                            array(
                                'id'    => 'video',
                                'type'  => 'text',
                                'title' => esc_html__( 'Video Url', 'moozo-elementor' ),
                            ),
                            array(
                                'id'    => 'gallery',
                                'type'  => 'gallery',
                                'title' => esc_html__( '360 Degree', 'moozo-elementor' ),
                            ),
                        ),
                    ),
                ),
            );
        }

        OVIC_Metabox::instance( apply_filters( 'moozo_framework_metabox_options', $sections ) );
    }

    add_action( 'init', 'moozo_metabox_options' );
}