<?php if ( !defined( 'ABSPATH' ) ) {
    die;
} // Cannot access pages directly.
/*==========================================================================
THEME BOX OPTIONS
===========================================================================*/
if ( !function_exists( 'moozo_theme_options' ) && class_exists( 'OVIC_Options' ) ) {
    function moozo_theme_options()
    {
        $vertical_menu = 'tools_o-01,tools_o-02,tools_o-03,fashion-modern-01,fashion-modern-04';
        $options       = array();
        // -----------------------------------------
        // Theme Options              -
        // -----------------------------------------
        $options['general_main'] = array(
            'name'     => 'general_main',
            'icon'     => 'fa fa-wordpress',
            'title'    => esc_html__( 'General', 'moozo-elementor' ),
            'sections' => array(
                array(
                    'title'  => esc_html__( 'General', 'moozo-elementor' ),
                    'fields' => array(
                        array(
                            'id'    => 'logo',
                            'type'  => 'image',
                            'title' => esc_html__( 'Logo', 'moozo-elementor' ),
                            'desc'  => esc_html__( 'Setting Logo For Site', 'moozo-elementor' ),
                        ),
                        array(
                            'id'      => 'main_skin',
                            'type'    => 'select',
                            'title'   => esc_html__( 'Main Skin', 'moozo-elementor' ),
                            'options' => array(
                                'accessories'    => esc_html__( 'Accessories', 'moozo-elementor' ),
                                'carparts'       => esc_html__( 'Carparts', 'moozo-elementor' ),
                                'cosmetics'      => esc_html__( 'Cosmetics', 'moozo-elementor' ),
                                'courses'        => esc_html__( 'Courses', 'moozo-elementor' ),
                                'fashion'        => esc_html__( 'Fashion', 'moozo-elementor' ),
                                'fashion-clean'  => esc_html__( 'Fashion Clean', 'moozo-elementor' ),
                                'fashion-modern' => esc_html__( 'Fashion Modern', 'moozo-elementor' ),
                                'fashion-simple' => esc_html__( 'Fashion Simple', 'moozo-elementor' ),
                                'furniture'      => esc_html__( 'Furniture', 'moozo-elementor' ),
                                'glasses'        => esc_html__( 'Glasses', 'moozo-elementor' ),
                                'jewelry'        => esc_html__( 'Jewelry', 'moozo-elementor' ),
                                'market'         => esc_html__( 'Market', 'moozo-elementor' ),
                                'market-gray'    => esc_html__( 'Market Gray', 'moozo-elementor' ),
                                'market-light'   => esc_html__( 'Market Light', 'moozo-elementor' ),
                                'medical'        => esc_html__( 'Medical', 'moozo-elementor' ),
                                'organic'        => esc_html__( 'Organic', 'moozo-elementor' ),
                                'tools'          => esc_html__( 'Tools', 'moozo-elementor' ),
                                'tools-orange'   => esc_html__( 'Tools Orange', 'moozo-elementor' ),
                            ),
                            'default' => 'tools',
                        ),
                        array(
                            'id'      => 'main_color',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#C90000',
                            'title'   => esc_html__( 'Main Color', 'moozo-elementor' ),
                        ),
                        array(
                            'id'      => 'main_color_2',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#0046c3',
                            'title'   => esc_html__( 'Main Color 2', 'moozo-elementor' ),
                        ),
                        array(
                            'id'      => 'main_container',
                            'type'    => 'slider',
                            'title'   => esc_html__( 'Main Container', 'moozo-elementor' ),
                            'min'     => 1140,
                            'max'     => 1920,
                            'step'    => 10,
                            'unit'    => esc_html__( 'px', 'moozo-elementor' ),
                            'default' => 1250,
                        ),
                        array(
                            'id'      => 'main_bora',
                            'type'    => 'spinner',
                            'title'   => esc_html__( 'Main Border Radius', 'moozo-elementor' ),
                            'min'     => 0,
                            'step'    => 1,
                            'unit'    => 'px',
                            'default' => 4,
                        ),
                        array(
                            'id'      => 'main_fw',
                            'type'    => 'select',
                            'title'   => esc_html__( 'Main Font Weight', 'moozo-elementor' ),
                            'options' => array(
                                400 => esc_html__( 'Regular', 'moozo-elementor' ),
                                500 => esc_html__( 'Medium', 'moozo-elementor' ),
                                600 => esc_html__( 'Semi-bold', 'moozo-elementor' ),
                                700 => esc_html__( 'Bold', 'moozo-elementor' ),
                            ),
                            'default' => '500',
                        ),
                        array(
                            'id'      => 'main_tt',
                            'type'    => 'select',
                            'title'   => esc_html__( 'Main Text Transform', 'moozo-elementor' ),
                            'options' => array(
                                'none'       => esc_html__( 'None', 'moozo-elementor' ),
                                'capitalize' => esc_html__( 'Capitalize', 'moozo-elementor' ),
                                'uppercase'  => esc_html__( 'Uppercase', 'moozo-elementor' ),
                            ),
                            'default' => 'none',
                        ),
                    ),
                ),
                array(
                    'title'  => esc_html__( 'Enable/Disable', 'moozo-elementor' ),
                    'fields' => array(
                        array(
                            'id'    => 'disable_equal',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Disable Equal Height', 'moozo-elementor' ),
                        ),
                        array(
                            'id'    => 'enable_cache_option',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Cache Options', 'moozo-elementor' ),
                        ),
                        array(
                            'id'    => 'enable_ajax_comment',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Nav Ajax Comment', 'moozo-elementor' ),
                        ),
                        array(
                            'id'    => 'enable_backtotop',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Back To Top Button', 'moozo-elementor' ),
                        ),
                        array(
                            'id'      => 'enable_ovic_rtl',
                            'type'    => 'switcher',
                            'title'   => esc_html__( 'Enable Ovic RTL', 'moozo-elementor' ),
                            'desc'    =>
                                '<ul>
                                    <li>' . esc_html__( 'If RTL Language:', 'moozo-elementor' ) . '</li>
                                    <li>' . esc_html__( '- Sections has class "rtl-bg" will be has rtl background', 'moozo-elementor' ) . '</li>
                                    <li>' . esc_html__( '- Align has direction left/right will be start/end', 'moozo-elementor' ) . '</li>
                                </ul>',
                            'default' => 1,
                        ),
                    ),
                ),
                array(
                    'title'  => esc_html__( 'Sidebar Settings', 'moozo-elementor' ),
                    'fields' => array(
                        array(
                            'id'      => 'sidebar_width',
                            'type'    => 'slider',
                            'title'   => esc_html__( 'Sidebar Width', 'moozo-elementor' ),
                            'min'     => 200,
                            'max'     => 400,
                            'step'    => 1,
                            'unit'    => esc_html__( 'px', 'moozo-elementor' ),
                            'default' => 270,
                        ),
                        array(
                            'id'      => 'sidebar_space',
                            'type'    => 'spinner',
                            'title'   => esc_html__( 'Sidebar Space', 'moozo-elementor' ),
                            'min'     => 0,
                            'max'     => 100,
                            'step'    => 1,
                            'unit'    => 'px',
                            'default' => 30,
                        ),
                        array(
                            'id'           => 'multi_sidebar',
                            'type'         => 'repeater',
                            'button_title' => esc_html__( 'Add Sidebar', 'moozo-elementor' ),
                            'title'        => esc_html__( 'Multi Sidebar', 'moozo-elementor' ),
                            'fields'       => array(
                                array(
                                    'id'    => 'add_sidebar',
                                    'type'  => 'text',
                                    'title' => esc_html__( 'Name Sidebar', 'moozo-elementor' ),
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'title'  => esc_html__( 'ACE Settings', 'moozo-elementor' ),
                    'fields' => array(
                        array(
                            'id'       => 'ace_style',
                            'type'     => 'code_editor',
                            'settings' => array(
                                'theme' => 'dracula',
                                'mode'  => 'css',
                            ),
                            'title'    => esc_html__( 'Editor Style', 'moozo-elementor' ),
                        ),
                        array(
                            'id'       => 'ace_script',
                            'type'     => 'code_editor',
                            'settings' => array(
                                'theme' => 'dracula',
                                'mode'  => 'javascript',
                            ),
                            'title'    => esc_html__( 'Editor Javascript', 'moozo-elementor' ),
                        ),
                    ),
                ),
            ),
        );
        $options['header_main']  = array(
            'name'     => 'header_main',
            'icon'     => 'fa fa-folder-open-o',
            'title'    => esc_html__( 'Header', 'moozo-elementor' ),
            'sections' => array(
                array(
                    'title'  => esc_html__( 'Header Main', 'moozo-elementor' ),
                    'fields' => array(
                        array(
                            'id'      => 'sticky_menu',
                            'type'    => 'button_set',
                            'title'   => esc_html__( 'Header Sticky', 'moozo-elementor' ),
                            'options' => array(
                                'none'     => esc_html__( 'None', 'moozo-elementor' ),
                                'template' => esc_html__( 'Template', 'moozo-elementor' ),
                                'jquery'   => esc_html__( 'jQuery', 'moozo-elementor' ),
                            ),
                            'default' => 'none',
                        ),
                        array(
                            'id'         => 'header_template',
                            'type'       => 'select_preview',
                            'title'      => esc_html__( 'Header Layout', 'moozo-elementor' ),
                            'options'    => moozo_file_options( '/templates/header/', 'header' ),
                            'default'    => 'tools-01',
                            'attributes' => array(
                                'data-depend-id' => 'header_template',
                            ),
                        ),
                        array(
                            'id'          => 'header_banner',
                            'type'        => 'select',
                            'options'     => 'page',
                            'chosen'      => true,
                            'ajax'        => true,
                            'placeholder' => esc_html__( 'None', 'moozo-elementor' ),
                            'title'       => esc_html__( 'Header Banner', 'moozo-elementor' ),
                            'desc'        => esc_html__( 'Get banner on header from page builder', 'moozo-elementor' ),
                        ),
                        array(
                            'id'    => 'header_message',
                            'type'  => 'textarea',
                            'title' => esc_html__( 'Header Message', 'moozo-elementor' ),
                        ),
                        array(
                            'id'          => 'extend_menu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Extend Menu', 'moozo-elementor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'moozo-elementor' ),
                        ),
                        array(
                            'id'          => 'language_menu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Language Menu', 'moozo-elementor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'moozo-elementor' ),
                        ),
                        array(
                            'id'    => 'social_menu',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Social Menu', 'moozo-elementor' ),
                        ),
                    ),
                ),
                array(
                    'title'  => esc_html__( 'Vertical Menu', 'moozo-elementor' ),
                    'fields' => array(
                        array(
                            'id'       => 'vertical_always_open',
                            'type'     => 'select',
                            'options'  => 'page',
                            'multiple' => true,
                            'chosen'   => true,
                            'ajax'     => true,
                            'title'    => esc_html__( 'Vertical Menu Always Open', 'moozo-elementor' ),
                        ),
                        array(
                            'type'       => 'notice',
                            'style'      => 'warning',
                            'content'    => esc_html__( 'Style header do not support vertical menu.', 'moozo-elementor' ),
                            'dependency' => array( 'header_template', 'not-any', $vertical_menu, true ),
                        ),
                        array(
                            'id'          => 'vertical_menu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Vertical Menu', 'moozo-elementor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'moozo-elementor' ),
                            'dependency'  => array( 'header_template', 'any', $vertical_menu, true ),
                        ),
                        array(
                            'id'         => 'vertical_title',
                            'type'       => 'text',
                            'title'      => esc_html__( 'Vertical Menu Title', 'moozo-elementor' ),
                            'default'    => esc_html__( 'Shop by category', 'moozo-elementor' ),
                            'dependency' => array( 'header_template', 'any', $vertical_menu, true ),
                        ),
                        array(
                            'id'         => 'vertical_height',
                            'type'       => 'spinner',
                            'title'      => esc_html__( 'Vertical Menu Height', 'moozo-elementor' ),
                            'dependency' => array( 'header_template', 'any', $vertical_menu, true ),
                        ),
                    ),
                ),
            ),
        );
        $options['footer_main']  = array(
            'name'   => 'footer_main',
            'icon'   => 'fa fa-folder-open-o',
            'title'  => esc_html__( 'Footer', 'moozo-elementor' ),
            'fields' => array(
                array(
                    'id'      => 'footer_template',
                    'type'    => 'select_preview',
                    'default' => 'tools-01',
                    'title'   => esc_html__( 'Footer Layout', 'moozo-elementor' ),
                    'options' => moozo_footer_preview(),
                ),
            ),
        );
        $options['mobile_main']  = array(
            'name'     => 'mobile_main',
            'icon'     => 'fa fa-wordpress',
            'title'    => esc_html__( 'Mobile', 'moozo-elementor' ),
            'sections' => array(
                array(
                    'title'  => esc_html__( 'Mobile Layout', 'moozo-elementor' ),
                    'fields' => array(
                        array(
                            'id'      => 'mobile_enable',
                            'type'    => 'switcher',
                            'title'   => esc_html__( 'Mobile version', 'moozo-elementor' ),
                            'default' => 1,
                        ),
                        array(
                            'id'    => 'logo_mobile',
                            'type'  => 'image',
                            'title' => esc_html__( 'Logo Mobile', 'moozo-elementor' ),
                            'desc'  => esc_html__( 'Setting Logo For Site', 'moozo-elementor' ),
                        ),
                        array(
                            'id'      => 'mobile_layout',
                            'type'    => 'image_select',
                            'default' => 'style-01',
                            'title'   => esc_html__( 'Mobile Layout', 'moozo-elementor' ),
                            'options' => array(
                                'style-01' => get_theme_file_uri( 'templates/mobile/mobile-style-01.png' ),
                                'style-02' => get_theme_file_uri( 'templates/mobile/mobile-style-02.png' ),
                            ),
                        ),
                        array(
                            'id'      => 'mobile_banner',
                            'type'    => 'switcher',
                            'title'   => esc_html__( 'Mobile Top Banner', 'moozo-elementor' ),
                            'default' => 1,
                        ),
                        array(
                            'id'      => 'background_mobile',
                            'type'    => 'background',
                            'title'   => esc_html__( 'Background Mobile', 'moozo-elementor' ),
                            'desc'    => esc_html__( 'Setting Background For Mobile Menu', 'moozo-elementor' ),
                            'default' => array(
                                'background-position'   => 'center center',
                                'background-repeat'     => 'no-repeat',
                                'background-attachment' => 'scroll',
                                'background-size'       => 'cover',
                            ),
                            'output'  => '.ovic-menu-clone-wrap .head-menu-mobile'
                        ),
                    )
                ),
                array(
                    'title'  => esc_html__( 'Mobile Content', 'moozo-elementor' ),
                    'fields' => array(
                        array(
                            'id'          => 'mobile_menu_top',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Mobile Menu Top', 'moozo-elementor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'moozo-elementor' ),
                        ),
                        array(
                            'id'          => 'mobile_menu_bottom',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Mobile Menu Bottom', 'moozo-elementor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'moozo-elementor' ),
                        ),
                        array(
                            'id'      => 'mobile_footer',
                            'type'    => 'select_preview',
                            'default' => 'inherit',
                            'title'   => esc_html__( 'Footer Mobile', 'moozo-elementor' ),
                            'options' => moozo_footer_preview( true ),
                        ),
                    )
                ),
            )
        );
        $options['posts_main']   = array(
            'name'     => 'posts_main',
            'icon'     => 'fa fa-rss',
            'title'    => esc_html__( 'Posts Settings', 'moozo-elementor' ),
            'sections' => array(
                array(
                    'title'  => esc_html__( 'Blog Page', 'moozo-elementor' ),
                    'fields' => array(
                        array(
                            'id'    => 'blog_title',
                            'type'  => 'text',
                            'title' => esc_html__( 'Blog Title', 'moozo-elementor' ),
                        ),
                        array(
                            'id'      => 'blog_list_style',
                            'type'    => 'select',
                            'title'   => esc_html__( 'Blog Style', 'moozo-elementor' ),
                            'options' => array(
                                'standard' => esc_html__( 'Standard', 'moozo-elementor' ),
                                'simple'   => esc_html__( 'Simple', 'moozo-elementor' ),
                                'list'     => esc_html__( 'List', 'moozo-elementor' ),
                                'grid'     => esc_html__( 'Grid', 'moozo-elementor' ),
                            ),
                            'default' => 'standard',
                        ),
                        array(
                            'id'      => 'sidebar_blog_layout',
                            'type'    => 'image_select',
                            'title'   => esc_html__( 'Sidebar Blog Layout', 'moozo-elementor' ),
                            'desc'    => esc_html__( 'Select sidebar position on Blog.', 'moozo-elementor' ),
                            'options' => array(
                                'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
                                'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
                                'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
                            ),
                            'default' => 'left',
                        ),
                        array(
                            'id'         => 'blog_used_sidebar',
                            'type'       => 'select',
                            'default'    => 'widget-area',
                            'title'      => esc_html__( 'Blog Sidebar', 'moozo-elementor' ),
                            'options'    => 'sidebars',
                            'dependency' => array( 'sidebar_blog_layout', '!=', 'full' ),
                        ),
                        array(
                            'id'    => 'enable_blog_sticky',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Sticky Post', 'moozo-elementor' ),
                        ),
                        array(
                            'id'         => 'blog_sticky',
                            'type'       => 'select',
                            'title'      => esc_html__( 'Blog Sticky Post', 'moozo-elementor' ),
                            'options'    => 'post',
                            'chosen'     => true,
                            'ajax'       => true,
                            'multiple'   => true,
                            'dependency' => array( 'enable_blog_sticky', '==', 1 ),
                        ),
                        array(
                            'id'      => 'blog_pagination',
                            'type'    => 'button_set',
                            'title'   => esc_html__( 'Blog Pagination', 'moozo-elementor' ),
                            'options' => array(
                                'pagination' => esc_html__( 'Pagination', 'moozo-elementor' ),
                                'load_more'  => esc_html__( 'Load More', 'moozo-elementor' ),
                                'infinite'   => esc_html__( 'Infinite Scrolling', 'moozo-elementor' ),
                            ),
                            'default' => 'pagination',
                            'desc'    => esc_html__( 'Select style pagination on blog page.', 'moozo-elementor' ),
                        ),
                    ),
                ),
                array(
                    'title'  => esc_html__( 'Post Single', 'moozo-elementor' ),
                    'fields' => array(
                        array(
                            'id'      => 'single_layout',
                            'type'    => 'select',
                            'default' => 'standard',
                            'title'   => esc_html__( 'Single Post Layout', 'moozo-elementor' ),
                            'options' => array(
                                'standard' => esc_html__( 'Standard', 'moozo-elementor' ),
                                'modern'   => esc_html__( 'Modern', 'moozo-elementor' ),
                            ),
                        ),
                        array(
                            'id'      => 'sidebar_single_layout',
                            'type'    => 'image_select',
                            'title'   => esc_html__( ' Sidebar Single Post Layout', 'moozo-elementor' ),
                            'desc'    => esc_html__( 'Select sidebar position on Blog.', 'moozo-elementor' ),
                            'options' => array(
                                'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
                                'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
                                'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
                            ),
                            'default' => 'left',
                        ),
                        array(
                            'id'         => 'single_used_sidebar',
                            'type'       => 'select',
                            'default'    => 'widget-area',
                            'title'      => esc_html__( 'Blog Single Sidebar', 'moozo-elementor' ),
                            'options'    => 'sidebars',
                            'dependency' => array( 'sidebar_single_layout', '!=', 'full' ),
                        ),
                        array(
                            'id'    => 'enable_share_post',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Share', 'moozo-elementor' ),
                        ),
                        array(
                            'id'    => 'enable_related_post',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Related', 'moozo-elementor' ),
                        ),
                        array(
                            'id'         => 'related_post_title',
                            'type'       => 'text',
                            'title'      => esc_html__( 'Related Posts Title', 'moozo-elementor' ),
                            'default'    => esc_html__( 'Related articles', 'moozo-elementor' ),
                            'dependency' => array( 'enable_related_post', '==', 1 ),
                        ),
                        array(
                            'id'         => 'related_post_perpage',
                            'type'       => 'spinner',
                            'title'      => esc_html__( 'Related Posts Items', 'moozo-elementor' ),
                            'dependency' => array( 'enable_related_post', '==', 1 ),
                            'default'    => 7,
                            'unit'       => 'item(s)',
                        ),
                    ),
                ),
            ),
        );
        if ( class_exists( 'WooCommerce' ) ) {
            $options['woocommerce_mains'] = array(
                'name'     => 'woocommerce_mains',
                'icon'     => 'fa fa-shopping-bag',
                'title'    => esc_html__( 'WooCommerce', 'moozo-elementor' ),
                'sections' => array(
                    array(
                        'title'  => esc_html__( 'Shop Page', 'moozo-elementor' ),
                        'fields' => array(
                            array(
                                'id'          => 'shop_builder_top',
                                'type'        => 'select',
                                'options'     => 'page',
                                'query_args'  => array(
                                    'posts_per_page' => -1,
                                ),
                                'chosen'      => true,
                                'ajax'        => true,
                                'placeholder' => esc_html__( 'Select Page', 'moozo-elementor' ),
                                'title'       => esc_html__( 'Shop Builder Top', 'moozo-elementor' ),
                                'desc'        => esc_html__( 'Get shop banner from page builder.', 'moozo-elementor' ),
                            ),
                            array(
                                'id'      => 'shop_builder_position',
                                'type'    => 'select',
                                'title'   => esc_html__( 'Shop Builder Position', 'moozo-elementor' ),
                                'options' => array(
                                    'outside' => esc_html__( 'Outside', 'moozo-elementor' ),
                                    'inside'  => esc_html__( 'Inside', 'moozo-elementor' ),
                                ),
                                'default' => 'outside',
                            ),
                            array(
                                'id'          => 'shop_builder_bot',
                                'type'        => 'select',
                                'options'     => 'page',
                                'query_args'  => array(
                                    'posts_per_page' => -1,
                                ),
                                'chosen'      => true,
                                'ajax'        => true,
                                'placeholder' => esc_html__( 'Select Page', 'moozo-elementor' ),
                                'title'       => esc_html__( 'Shop Builder Bottom', 'moozo-elementor' ),
                                'desc'        => esc_html__( 'Get shop banner from page builder.', 'moozo-elementor' ),
                            ),
                            array(
                                'id'      => 'shop_page_layout',
                                'type'    => 'image_select',
                                'default' => 'grid',
                                'title'   => esc_html__( 'Shop Layout', 'moozo-elementor' ),
                                'desc'    => esc_html__( 'Select layout for shop product, product category archive.',
                                    'moozo-elementor' ),
                                'options' => array(
                                    'grid' => get_theme_file_uri( 'assets/images/grid-display.png' ),
                                    'list' => get_theme_file_uri( 'assets/images/list-display.png' ),
                                ),
                            ),
                            array(
                                'id'      => 'product_loop_columns',
                                'type'    => 'spinner',
                                'title'   => esc_html__( 'Products Columns', 'moozo-elementor' ),
                                'desc'    => esc_html__( 'for Grid', 'moozo-elementor' ),
                                'max'     => 6,
                                'min'     => 2,
                                'step'    => 1,
                                'unit'    => 'columns',
                                'default' => 4,
                            ),
                            array(
                                'id'      => 'product_per_page',
                                'type'    => 'spinner',
                                'default' => '10',
                                'unit'    => 'items',
                                'title'   => esc_html__( 'Products Per Page', 'moozo-elementor' ),
                            ),
                            array(
                                'id'      => 'product_newness',
                                'default' => '100',
                                'type'    => 'spinner',
                                'unit'    => 'days',
                                'title'   => esc_html__( 'Products Newness', 'moozo-elementor' ),
                            ),
                            array(
                                'id'      => 'product_hover',
                                'type'    => 'button_set',
                                'title'   => esc_html__( 'Product Image Hover', 'moozo-elementor' ),
                                'options' => array(
                                    ''       => esc_html__( 'None', 'moozo-elementor' ),
                                    'zoom'   => esc_html__( 'Zoom Image', 'moozo-elementor' ),
                                    'change' => esc_html__( 'Change Image', 'moozo-elementor' ),
                                    'slide'  => esc_html__( 'Slide Image', 'moozo-elementor' ),
                                ),
                                'default' => '',
                            ),
                            array(
                                'id'      => 'woocommerce_pagination',
                                'type'    => 'button_set',
                                'title'   => esc_html__( 'Shop Pagination', 'moozo-elementor' ),
                                'options' => array(
                                    'pagination' => esc_html__( 'Pagination', 'moozo-elementor' ),
                                    'load_more'  => esc_html__( 'Load More', 'moozo-elementor' ),
                                    'infinite'   => esc_html__( 'Infinite Scrolling', 'moozo-elementor' ),
                                ),
                                'default' => 'pagination',
                                'desc'    => esc_html__( 'Select style pagination on shop page.', 'moozo-elementor' ),
                            ),
                        ),
                    ),
                    array(
                        'title'  => esc_html__( 'Shop Page Sidebar', 'moozo-elementor' ),
                        'fields' => array(
                            array(
                                'id'      => 'sidebar_shop_layout',
                                'type'    => 'image_select',
                                'title'   => esc_html__( 'Shop Page Sidebar Layout', 'moozo-elementor' ),
                                'desc'    => esc_html__( 'Select sidebar position on Shop Page.', 'moozo-elementor' ),
                                'options' => array(
                                    'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
                                    'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
                                    'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
                                ),
                                'default' => 'left',
                            ),
                            array(
                                'id'         => 'shop_used_sidebar',
                                'type'       => 'select',
                                'default'    => 'shop-widget-area',
                                'title'      => esc_html__( 'Sidebar Used For Shop', 'moozo-elementor' ),
                                'options'    => 'sidebars',
                                'dependency' => array( 'sidebar_shop_layout', '!=', 'full' ),
                            ),
                            array(
                                'id'         => 'shop_vendor_used_sidebar',
                                'type'       => 'select',
                                'title'      => esc_html__( 'Sidebar Used For Vendor', 'moozo-elementor' ),
                                'options'    => 'sidebars',
                                'dependency' => array( 'sidebar_shop_layout', '!=', 'full' ),
                            ),
                            array(
                                'id'    => 'shop_sidebar_width',
                                'type'  => 'slider',
                                'title' => esc_html__( 'Sidebar Width', 'moozo-elementor' ),
                                'desc'  => esc_html__( 'Default is General / Sidebar settings', 'moozo-elementor' ),
                                'min'   => 200,
                                'max'   => 400,
                                'step'  => 1,
                                'unit'  => esc_html__( 'px', 'moozo-elementor' ),
                            ),
                            array(
                                'id'    => 'shop_sidebar_space',
                                'type'  => 'spinner',
                                'title' => esc_html__( 'Sidebar Space', 'moozo-elementor' ),
                                'desc'  => esc_html__( 'Default is General / Sidebar settings', 'moozo-elementor' ),
                                'min'   => 0,
                                'max'   => 100,
                                'step'  => 1,
                                'unit'  => 'px',
                            ),
                        ),
                    ),
                    array(
                        'title'  => esc_html__( 'Shop Page Items', 'moozo-elementor' ),
                        'fields' => array(
                            array(
                                'id'      => 'shop_product_style',
                                'type'    => 'select_preview',
                                'default' => 'style-01',
                                'title'   => esc_html__( 'Grid Items Style', 'moozo-elementor' ),
                                'options' => moozo_product_options( 'Theme Option' ),
                            ),
                            array(
                                'id'      => 'shop_product_list_style',
                                'type'    => 'select_preview',
                                'default' => 'style-01',
                                'title'   => esc_html__( 'List Items Style', 'moozo-elementor' ),
                                'options' => moozo_file_options( '/woocommerce/product-list-style/', 'content-product' ),
                            ),
                            array(
                                'id'    => 'disable_labels',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Disable Labels', 'moozo-elementor' ),
                            ),
                            array(
                                'id'    => 'disable_rating',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Disable Rating', 'moozo-elementor' ),
                            ),
                            array(
                                'id'    => 'short_text',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Short Title', 'moozo-elementor' ),
                            ),
                            array(
                                'id'    => 'enable_short_title',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Short Title on Mobile ( < 768px )', 'moozo-elementor' ),
                            ),
                        ),
                    ),
                    array(
                        'title'  => esc_html__( 'Product Single', 'moozo-elementor' ),
                        'fields' => array(
                            array(
                                'id'      => 'single_product_style',
                                'type'    => 'select_preview',
                                'default' => 'style-01',
                                'title'   => esc_html__( 'Single Product Layout', 'moozo-elementor' ),
                                'options' => array(
                                    'style-01' => array(
                                        'title'   => esc_html__( 'Single Product 01', 'moozo-elementor' ),
                                        'preview' => get_theme_file_uri( 'woocommerce/single-product/single-product-style/content-single-product-style-01.jpg' )
                                    ),
                                    'style-02' => array(
                                        'title'   => esc_html__( 'Single Product 02', 'moozo-elementor' ),
                                        'preview' => get_theme_file_uri( 'woocommerce/single-product/single-product-style/content-single-product-style-02.jpg' )
                                    ),
                                    'style-03' => array(
                                        'title'   => esc_html__( 'Single Product 03', 'moozo-elementor' ),
                                        'preview' => get_theme_file_uri( 'woocommerce/single-product/single-product-style/content-single-product-style-03.jpg' )
                                    ),
                                    'style-04' => array(
                                        'title'   => esc_html__( 'Single Product 04', 'moozo-elementor' ),
                                        'preview' => get_theme_file_uri( 'woocommerce/single-product/single-product-style/content-single-product-style-04.jpg' )
                                    ),
                                    'style-05' => array(
                                        'title'   => esc_html__( 'Single Product 05', 'moozo-elementor' ),
                                        'preview' => get_theme_file_uri( 'woocommerce/single-product/single-product-style/content-single-product-style-05.jpg' )
                                    ),
                                    'style-06' => array(
                                        'title'   => esc_html__( 'Single Product 06', 'moozo-elementor' ),
                                        'preview' => get_theme_file_uri( 'woocommerce/single-product/single-product-style/content-single-product-style-06.jpg' )
                                    ),
                                    'style-07' => array(
                                        'title'   => esc_html__( 'Single Product 07', 'moozo-elementor' ),
                                        'preview' => get_theme_file_uri( 'woocommerce/single-product/single-product-style/content-single-product-style-07.jpg' )
                                    ),
                                    'style-08' => array(
                                        'title'   => esc_html__( 'Single Product 08', 'moozo-elementor' ),
                                        'preview' => get_theme_file_uri( 'woocommerce/single-product/single-product-style/content-single-product-style-08.jpg' )
                                    ),
                                    'style-09' => array(
                                        'title'   => esc_html__( 'Single Product 09', 'moozo-elementor' ),
                                        'preview' => get_theme_file_uri( 'woocommerce/single-product/single-product-style/content-single-product-style-09.jpg' )
                                    ),
                                ),
                            ),
                            array(
                                'id'      => 'single_product_tabs',
                                'type'    => 'select',
                                'title'   => esc_html__( 'Single Product Tabs', 'moozo-elementor' ),
                                'options' => array(
                                    ''                 => esc_html__( 'Default', 'moozo-elementor' ),
                                    'tabs-toggle'      => esc_html__( 'Toggle', 'moozo-elementor' ),
                                    'tabs-toggle-full' => esc_html__( 'Toggle Full', 'moozo-elementor' ),
                                    'tabs-show-all'    => esc_html__( 'Show All', 'moozo-elementor' ),
                                ),
                                'default' => '',
                            ),
                            array(
                                'id'    => 'add_image',
                                'type'  => 'image',
                                'title' => esc_html__( 'Image introduction', 'moozo-elementor' ),
                                'desc'  => esc_html__( 'Select a image about product', 'moozo-elementor' ),
                            ),
                            array(
                                'id'              => 'add_iconbox',
                                'type'            => 'group',
                                'title'           => esc_html__( 'Icon Box', 'moozo-elementor' ),
                                'button_title'    => esc_html__( 'Add item', 'moozo-elementor' ),
                                'accordion_title' => esc_html__( 'Add New item', 'moozo-elementor' ),
                                'fields'          => array(
                                    array(
                                        'id'    => 'iconbox_text',
                                        'type'  => 'textarea',
                                        'title' => esc_html__( 'Enter text here', 'moozo-elementor' ),
                                    ),
                                    array(
                                        'id'    => 'iconbox_icon',
                                        'type'  => 'icon',
                                        'title' => esc_html__( 'Select icon', 'moozo-elementor' ),
                                    ),
                                ),
                                'dependency'      => array( 'single_product_style', '==', 'style-08' ),
                            ),
                            array(
                                'id'    => 'add_delivery',
                                'type'  => 'text',
                                'title' => esc_html__( 'Delivery & Return', 'moozo-elementor' ),
                                'desc'  => esc_html__( 'Add link to Delivery & Return for product', 'moozo-elementor' ),
                            ),
                            array(
                                'id'    => 'enable_countdown_product',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Enable Countdown', 'moozo-elementor' ),
                            ),
                            array(
                                'id'    => 'enable_share_product',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Enable Share', 'moozo-elementor' ),
                            ),
                            array(
                                'id'    => 'disable_zoom',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Disable Zoom Gallery', 'moozo-elementor' ),
                            ),
                            array(
                                'id'    => 'disable_lightbox',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Disable Lightbox Gallery', 'moozo-elementor' ),
                            ),
                        ),
                    ),
                    array(
                        'title'  => esc_html__( 'Related Products', 'moozo-elementor' ),
                        'fields' => array(
                            array(
                                'id'      => 'woo_related_enable',
                                'type'    => 'button_set',
                                'default' => 'enable',
                                'options' => array(
                                    'enable'  => esc_html__( 'Enable', 'moozo-elementor' ),
                                    'disable' => esc_html__( 'Disable', 'moozo-elementor' ),
                                ),
                                'title'   => esc_html__( 'Enable Related Products', 'moozo-elementor' ),
                            ),
                            array(
                                'id'         => 'woo_related_title',
                                'type'       => 'text',
                                'title'      => esc_html__( 'Related products title', 'moozo-elementor' ),
                                'desc'       => esc_html__( 'Related products title', 'moozo-elementor' ),
                                'dependency' => array( 'woo_related_enable', '==', 'enable' ),
                                'default'    => esc_html__( 'Related Products', 'moozo-elementor' ),
                            ),
                            array(
                                'id'         => 'woo_related_style',
                                'type'       => 'select_preview',
                                'default'    => 'style-01',
                                'title'      => esc_html__( 'Product Related Layout', 'moozo-elementor' ),
                                'options'    => moozo_product_options( 'Theme Option' ),
                                'dependency' => array( 'woo_related_enable', '==', 'enable' ),
                            ),
                            array(
                                'id'         => 'woo_related_perpage',
                                'type'       => 'spinner',
                                'title'      => esc_html__( 'Related products Items', 'moozo-elementor' ),
                                'desc'       => esc_html__( 'Number Related products to show', 'moozo-elementor' ),
                                'dependency' => array( 'woo_related_enable', '==', 'enable' ),
                                'default'    => 6,
                                'unit'       => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_related_desktop',
                                'title'   => esc_html__( 'items on Desktop', 'moozo-elementor' ),
                                'desc'    => esc_html__( '1500px <= resolution', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 5,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_related_laptop',
                                'title'   => esc_html__( 'items on Laptop', 'moozo-elementor' ),
                                'desc'    => esc_html__( '1200px <= resolution < 1500px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 5,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_related_ipad',
                                'title'   => esc_html__( 'items on Ipad', 'moozo-elementor' ),
                                'desc'    => esc_html__( '992px <= resolution < 1200px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 4,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_related_landscape',
                                'title'   => esc_html__( 'items on Landscape Tablet', 'moozo-elementor' ),
                                'desc'    => esc_html__( '768px <= resolution < 992px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 4,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_related_portrait',
                                'title'   => esc_html__( 'items on Portrait Tablet', 'moozo-elementor' ),
                                'desc'    => esc_html__( '480px <= resolution < 768px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 3,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_related_mobile',
                                'title'   => esc_html__( 'items on Mobile', 'moozo-elementor' ),
                                'desc'    => esc_html__( 'resolution < 480px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 2,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                        ),
                    ),
                    array(
                        'title'  => esc_html__( 'Upsell Products', 'moozo-elementor' ),
                        'fields' => array(
                            array(
                                'id'      => 'woo_upsell_enable',
                                'type'    => 'button_set',
                                'default' => 'enable',
                                'options' => array(
                                    'enable'  => esc_html__( 'Enable', 'moozo-elementor' ),
                                    'disable' => esc_html__( 'Disable', 'moozo-elementor' ),
                                ),
                                'title'   => esc_html__( 'Enable Upsell Products', 'moozo-elementor' ),
                            ),
                            array(
                                'id'         => 'woo_upsell_title',
                                'type'       => 'text',
                                'title'      => esc_html__( 'Upsell products title', 'moozo-elementor' ),
                                'desc'       => esc_html__( 'Upsell products title', 'moozo-elementor' ),
                                'dependency' => array( 'woo_upsell_enable', '==', 'enable' ),
                                'default'    => esc_html__( 'Upsell Products', 'moozo-elementor' ),
                            ),
                            array(
                                'id'         => 'woo_upsell_style',
                                'type'       => 'select_preview',
                                'default'    => 'style-01',
                                'title'      => esc_html__( 'Product Upsell Layout', 'moozo-elementor' ),
                                'options'    => moozo_product_options( 'Theme Option' ),
                                'dependency' => array( 'woo_upsell_enable', '==', 'enable' ),
                            ),
                            array(
                                'id'      => 'woo_upsell_desktop',
                                'title'   => esc_html__( 'items on Desktop', 'moozo-elementor' ),
                                'desc'    => esc_html__( '1500px <= resolution', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 5,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_upsell_laptop',
                                'title'   => esc_html__( 'items on Laptop', 'moozo-elementor' ),
                                'desc'    => esc_html__( '1200px <= resolution < 1500px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 5,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_upsell_ipad',
                                'title'   => esc_html__( 'items on Ipad', 'moozo-elementor' ),
                                'desc'    => esc_html__( '992px <= resolution < 1200px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 4,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_upsell_landscape',
                                'title'   => esc_html__( 'items on Landscape Tablet', 'moozo-elementor' ),
                                'desc'    => esc_html__( '768px <= resolution < 992px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 4,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_upsell_portrait',
                                'title'   => esc_html__( 'items on Portrait Tablet', 'moozo-elementor' ),
                                'desc'    => esc_html__( '480px <= resolution < 768px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 3,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_upsell_mobile',
                                'title'   => esc_html__( 'items on Mobile', 'moozo-elementor' ),
                                'desc'    => esc_html__( 'resolution < 480px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 2,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                        ),
                    ),
                    array(
                        'title'  => esc_html__( 'Cross Sell Products', 'moozo-elementor' ),
                        'fields' => array(
                            array(
                                'id'      => 'woo_crosssell_enable',
                                'type'    => 'button_set',
                                'default' => 'enable',
                                'options' => array(
                                    'enable'  => esc_html__( 'Enable', 'moozo-elementor' ),
                                    'disable' => esc_html__( 'Disable', 'moozo-elementor' ),
                                ),
                                'title'   => esc_html__( 'Enable Cross Sell Products', 'moozo-elementor' ),
                            ),
                            array(
                                'id'         => 'woo_crosssell_title',
                                'type'       => 'text',
                                'title'      => esc_html__( 'Cross Sell products title', 'moozo-elementor' ),
                                'desc'       => esc_html__( 'Cross Sell products title', 'moozo-elementor' ),
                                'dependency' => array( 'woo_crosssell_enable', '==', 'enable' ),
                                'default'    => esc_html__( 'Cross Sell Products', 'moozo-elementor' ),
                            ),
                            array(
                                'id'         => 'woo_crosssell_style',
                                'type'       => 'select_preview',
                                'default'    => 'style-01',
                                'title'      => esc_html__( 'Product Cross Sell Layout', 'moozo-elementor' ),
                                'options'    => moozo_product_options( 'Theme Option' ),
                                'dependency' => array( 'woo_crosssell_enable', '==', 'enable' ),
                            ),
                            array(
                                'id'      => 'woo_crosssell_desktop',
                                'title'   => esc_html__( 'items on Desktop', 'moozo-elementor' ),
                                'desc'    => esc_html__( '1500px <= resolution', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 5,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_crosssell_laptop',
                                'title'   => esc_html__( 'items on Laptop', 'moozo-elementor' ),
                                'desc'    => esc_html__( '1200px <= resolution < 1500px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 5,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_crosssell_ipad',
                                'title'   => esc_html__( 'items on Ipad', 'moozo-elementor' ),
                                'desc'    => esc_html__( '992px <= resolution < 1200px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 4,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_crosssell_landscape',
                                'title'   => esc_html__( 'items on Landscape Tablet', 'moozo-elementor' ),
                                'desc'    => esc_html__( '768px <= resolution < 992px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 4,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_crosssell_portrait',
                                'title'   => esc_html__( 'items on Portrait Tablet', 'moozo-elementor' ),
                                'desc'    => esc_html__( '480px <= resolution < 768px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 3,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_crosssell_mobile',
                                'title'   => esc_html__( 'items on Mobile', 'moozo-elementor' ),
                                'desc'    => esc_html__( 'resolution < 480px', 'moozo-elementor' ),
                                'type'    => 'slider',
                                'default' => 2,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                        ),
                    ),
                ),
            );
        }
        $options['social']     = array(
            'name'   => 'social',
            'icon'   => 'fa fa-users',
            'title'  => esc_html__( 'Social', 'moozo-elementor' ),
            'fields' => array(
                array(
                    'id'              => 'user_all_social',
                    'type'            => 'group',
                    'title'           => esc_html__( 'Social', 'moozo-elementor' ),
                    'button_title'    => esc_html__( 'Add New Social', 'moozo-elementor' ),
                    'accordion_title' => esc_html__( 'Social Settings', 'moozo-elementor' ),
                    'fields'          => array(
                        array(
                            'id'      => 'title_social',
                            'type'    => 'text',
                            'title'   => esc_html__( 'Title Social', 'moozo-elementor' ),
                            'default' => 'Facebook',
                        ),
                        array(
                            'id'      => 'link_social',
                            'type'    => 'text',
                            'title'   => esc_html__( 'Link Social', 'moozo-elementor' ),
                            'default' => 'https://facebook.com',
                        ),
                        array(
                            'id'      => 'icon_social',
                            'type'    => 'icon',
                            'title'   => esc_html__( 'Icon Social', 'moozo-elementor' ),
                            'default' => 'fa fa-facebook',
                        ),
                    ),
                    'default'         => array(
                        array(
                            'title_social' => 'Facebook',
                            'link_social'  => 'https://facebook.com/',
                            'icon_social'  => 'fa fa-facebook',
                        ),
                        array(
                            'title_social' => 'Twitter',
                            'link_social'  => 'https://twitter.com/',
                            'icon_social'  => 'fa fa-twitter',
                        ),
                        array(
                            'title_social' => 'Youtube',
                            'link_social'  => 'https://youtube.com/',
                            'icon_social'  => 'fa fa-youtube',
                        ),
                        array(
                            'title_social' => 'Pinterest',
                            'link_social'  => 'https://pinterest.com/',
                            'icon_social'  => 'fa fa-pinterest',
                        ),
                        array(
                            'title_social' => 'Instagram',
                            'link_social'  => 'https://instagram.com/',
                            'icon_social'  => 'fa fa-instagram',
                        ),
                    ),
                ),
            ),
        );
        $options['typography'] = array(
            'name'   => 'typography',
            'icon'   => 'fa fa-font',
            'title'  => esc_html__( 'Typography', 'moozo-elementor' ),
            'fields' => array(
                array(
                    'id'             => 'body_typography',
                    'type'           => 'typography',
                    'title'          => esc_html__( 'Typography of Body', 'moozo-elementor' ),
                    'font_family'    => true,
                    'font_weight'    => true,
                    'font_style'     => true,
                    'subset'         => true,
                    'text_align'     => true,
                    'text_transform' => true,
                    'font_size'      => true,
                    'line_height'    => true,
                    'letter_spacing' => true,
                    'extra_styles'   => true,
                    'color'          => true,
                    'output'         => 'body',
                ),
            ),
        );
        $options['backup']     = array(
            'name'   => 'backup',
            'icon'   => 'fa fa-bold',
            'title'  => esc_html__( 'Backup / Reset', 'moozo-elementor' ),
            'fields' => array(
                array(
                    'id'    => 'reset',
                    'type'  => 'backup',
                    'title' => esc_html__( 'Reset', 'moozo-elementor' ),
                ),
                array(
                    'id'      => 'delete_transients',
                    'type'    => 'content',
                    'content' => '<a href="#" data-text-done="' . esc_attr__( '%n transient database entries have been deleted.', 'moozo-elementor' ) . '" class="button button-primary delete-transients"/>' . esc_html__( 'Delete Transients', 'moozo-elementor' ) . '</a><span class="spinner" style="float:none;"></span>',
                    'title'   => esc_html__( 'Delete Transients', 'moozo-elementor' ),
                    'desc'    => esc_html__( 'All transient related database entries will be deleted.', 'moozo-elementor' ),
                    'after'   => ' <p class="ovic-text-success"></p>',
                ),
            ),
        );
        //
        // Framework Settings
        //
        $settings = array(
            'option_name'      => '_ovic_customize_options',
            'menu_title'       => esc_html__( 'Theme Options', 'moozo-elementor' ),
            'menu_type'        => 'submenu', // menu, submenu, options, theme, etc.
            'menu_parent'      => 'ovic_addon-dashboard',
            'menu_slug'        => 'ovic_theme_options',
            'menu_position'    => 5,
            'show_search'      => true,
            'show_reset'       => true,
            'show_footer'      => false,
            'show_all_options' => true,
            'ajax_save'        => true,
            'sticky_header'    => false,
            'save_defaults'    => true,
            'framework_title'  => sprintf(
                '%s <small>%s <a href="%s" target="_blank">%s</a></small>',
                esc_html__( 'Theme Options', 'moozo-elementor' ),
                esc_html__( 'by', 'moozo-elementor' ),
                esc_url( 'https://kutethemes.com/' ),
                esc_html__( 'Kutethemes', 'moozo-elementor' )
            ),
        );

        OVIC_Options::instance( $settings, apply_filters( 'moozo_framework_theme_options', $options ) );
    }

    add_action( 'init', 'moozo_theme_options' );
}