<?php
if (!defined('ABSPATH')) {
    exit();
}

use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Blog extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_blog';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Blog', 'moozo-elementor');
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-post-list';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_section',
            array(
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__('General', 'moozo-elementor'),
            )
        );

        $this->add_control(
            'style',
            [
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__('Select style', 'moozo-elementor'),
                'options' => moozo_preview_options($this->get_name()),
                'default' => 'style-01',
            ]
        );

        $this->add_control(
            'image_full_size',
            [
                'label' => esc_html__('Image Full size', 'moozo-elementor'),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'target',
            [
                'label'   => esc_html__('Target', 'moozo-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'recent_post' => esc_html__('Latest', 'moozo-elementor'),
                    'popularity'  => esc_html__('Popularity', 'moozo-elementor'),
                    'date'        => esc_html__('Date', 'moozo-elementor'),
                    'title'       => esc_html__('Title', 'moozo-elementor'),
                    'post'        => esc_html__('Post', 'moozo-elementor'),
                    'random'      => esc_html__('Random', 'moozo-elementor'),
                ],
                'default' => 'recent_post',
            ]
        );

        if (class_exists('ElementorPro\Modules\QueryControl\Module')) {
            $this->add_control(
                'ids',
                [
                    'label'        => esc_html__('Search Post', 'moozo-elementor'),
                    'type'         => ElementorPro\Modules\QueryControl\Module::QUERY_CONTROL_ID,
                    'options'      => [],
                    'label_block'  => true,
                    'multiple'     => true,
                    'autocomplete' => [
                        'object' => ElementorPro\Modules\QueryControl\Module::QUERY_OBJECT_POST,
                        'query'  => [
                            'post_type' => 'post'
                        ],
                    ],
                    'condition'    => [
                        'target' => 'post'
                    ],
                    'export'       => false,
                ]
            );
        } else {
            $this->add_control(
                'ids',
                [
                    'label'       => esc_html__('Post', 'moozo-elementor'),
                    'type'        => Controls_Manager::TEXT,
                    'description' => esc_html__('Post ids', 'moozo-elementor'),
                    'placeholder' => '1,2,3',
                    'label_block' => true,
                    'condition'   => [
                        'target' => 'post'
                    ],
                ]
            );
        }

        $this->add_control(
            'category',
            [
                'label'       => esc_html__('Category', 'moozo-elementor'),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_taxonomy([
                    'meta_key'   => '',
                    'hide_empty' => true,
                ]),
                'label_block' => true,
                'condition'   => [
                    'target!' => 'post'
                ],
            ]
        );

        $this->add_control(
            'limit',
            [
                'label'       => esc_html__('Limit', 'moozo-elementor'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 6,
                'placeholder' => 6,
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label'   => esc_html__('Order by', 'moozo-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ''              => esc_html__('None', 'moozo-elementor'),
                    'date'          => esc_html__('Date', 'moozo-elementor'),
                    'ID'            => esc_html__('ID', 'moozo-elementor'),
                    'author'        => esc_html__('Author', 'moozo-elementor'),
                    'title'         => esc_html__('Title', 'moozo-elementor'),
                    'modified'      => esc_html__('Modified', 'moozo-elementor'),
                    'rand'          => esc_html__('Random', 'moozo-elementor'),
                    'comment_count' => esc_html__('Comment count', 'moozo-elementor'),
                    'menu_order'    => esc_html__('Menu order', 'moozo-elementor'),
                    'post__in'      => esc_html__('Post In', 'moozo-elementor'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label'   => esc_html__('Sort order', 'moozo-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ''     => esc_html__('None', 'moozo-elementor'),
                    'DESC' => esc_html__('Descending', 'moozo-elementor'),
                    'ASC'  => esc_html__('Ascending', 'moozo-elementor'),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'carousel_section',
            [
                'tab'   => Controls_Manager::TAB_SETTINGS,
                'label' => esc_html__('Carousel settings', 'moozo-elementor'),
            ]
        );

        $this->add_control(
            'slide_nav',
            [
                'label'   => esc_html__('Nav style', 'moozo-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => moozo_nav_style(),
                'default' => '',
            ]
        );

        $this->carousel_settings(false);

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        echo ovic_do_shortcode($this->get_name(), $settings);
    }
}