<?php
if (!defined('ABSPATH')) {
    exit();
}

use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Brand extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_brand';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Brand', 'moozo-elementor');
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-review';
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'general_section',
            array(
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__('General', 'moozo-elementor'),
            )
        );

        $this->add_control(
            'category',
            [
                'label'       => esc_html__('Products Brand', 'moozo-elementor'),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_taxonomy([
                    'hide_empty' => false,
                    'taxonomy'   => 'product_brand',
                ]),
                'multiple'    => true,
                'label_block' => true,
            ]
        );

        $this->add_responsive_control(
            'height',
            [
                'label'     => esc_html__('Height', 'moozo-elementor'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .brand-item .link' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'space',
            [
                'label'      => esc_html__('Spacing', 'moozo-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .brand-item .link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'image_effect',
            [
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__('Ovic Hover Animation', 'moozo-elementor'),
                'options' => [
                    'none'                          => esc_html__('None', 'moozo-elementor'),
                    'effect normal-effect'          => esc_html__('Normal Effect', 'moozo-elementor'),
                    'effect normal-effect dark-bg'  => esc_html__('Normal Effect Dark', 'moozo-elementor'),
                    'effect effect faded-in'        => esc_html__('Faded In', 'moozo-elementor'),
                    'effect bounce-in'              => esc_html__('Bounce In', 'moozo-elementor'),
                    'effect gray-filter'            => esc_html__('Gray Filter', 'moozo-elementor'),
                    'effect background-zoom'        => esc_html__('Background Zoom', 'moozo-elementor'),
                    'effect background-slide'       => esc_html__('Background Slide', 'moozo-elementor'),
                    'effect rotate-in rotate-left'  => esc_html__('Rotate Left In', 'moozo-elementor'),
                    'effect rotate-in rotate-right' => esc_html__('Rotate Right In', 'moozo-elementor'),
                    'effect plus-zoom'              => esc_html__('Plus Zoom', 'moozo-elementor'),
                    'effect border-zoom'            => esc_html__('Border Zoom', 'moozo-elementor'),
                    'effect border-scale'           => esc_html__('Border ScaleUp', 'moozo-elementor'),
                    'effect border-plus'            => esc_html__('Border Plus', 'moozo-elementor'),
                    'effect overlay-plus'           => esc_html__('Overlay Plus', 'moozo-elementor'),
                    'effect overlay-cross'          => esc_html__('Overlay Cross', 'moozo-elementor'),
                    'effect overlay-horizontal'     => esc_html__('Overlay Horizontal', 'moozo-elementor'),
                    'effect overlay-vertical'       => esc_html__('Overlay Vertical', 'moozo-elementor'),
                    'effect flashlight'             => esc_html__('Flashlight', 'moozo-elementor'),
                ],
                'default' => 'none',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'carousel_section',
            [
                'tab'   => Controls_Manager::TAB_SETTINGS,
                'label' => esc_html__('Carousel settings', 'moozo-elementor'),
            ]
        );

        $this->add_control(
            'slide_nav',
            [
                'label'   => esc_html__('Nav style', 'moozo-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => moozo_nav_style(),
                'default' => '',
            ]
        );

        $this->carousel_settings(false);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (!empty($settings['text_button'])) {
            $this->add_render_attribute('_wrapper', 'class', 'has-button');
        }

        echo ovic_do_shortcode($this->get_name(), $settings);
    }
}