<?php
if ( !defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Brand"
 * @version 1.0.0
 */
class Shortcode_Ovic_Brand extends Ovic_Addon_Shortcode
{
    /**
     * Shortcode name.
     *
     * @var  string
     */
    public $shortcode      = 'ovic_brand';
    public $is_woocommerce = true;
    public $default        = array(
        'slides_rows_space' => '',
        'slide_nav'         => '',
    );

    public function content( $atts, $content = null )
    {
        $owl_settings = $this->generate_carousel( $atts );
        $css_class    = $this->main_class( $atts,
            array(
                'ovic-brand',
                $atts['slides_rows_space'],
                $atts['slide_nav'],
            )
        );
        ob_start(); ?>
        <div class="<?php echo esc_attr( $css_class ); ?>">
            <?php if ( !empty( $atts['category'] ) ): ?>
                <div class="owl-slick" <?php echo esc_attr( $owl_settings ); ?>>
                    <?php foreach ( $atts['category'] as $category ) : ?>
                        <?php
                        $term = get_term_by( 'slug', $category, 'product_brand' );
                        if ( !is_wp_error( $term ) && !empty( $term ) ): ?>
                            <?php
                            $term_link    = get_term_link( $term->term_id, 'product_brand' );
                            $thumbnail_id = get_term_meta( $term->term_id, 'logo_id', true );
                            ?>
                            <div class="brand-item">
                                <a href="<?php echo esc_url( $term_link ); ?>"
                                   class="link <?php echo esc_attr( $atts['image_effect'] ); ?>">
                                    <?php if ( !empty( $thumbnail_id ) ) : ?>
                                        <figure class="thumb">
                                            <img src="<?php echo wp_get_attachment_image_url( $thumbnail_id, 'full' ); ?>"
                                                 alt="<?php echo esc_attr( $term->name ); ?>">
                                        </figure>
                                    <?php else: ?>
                                        <span class="name"><?php echo esc_html( $term->name ); ?></span>
                                    <?php endif; ?>
                                </a>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
        <?php
        return ob_get_clean();
    }
}