<?php
if ( !defined( 'ABSPATH' ) ) {
    exit();
}

use Elementor\Core\Schemes;
use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Countdown extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_countdown';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__( 'Countdown', 'moozo-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-countdown';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_section',
            array(
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__( 'General', 'moozo-elementor' ),
            )
        );

        $this->add_control(
            'date',
            [
                'type'           => Controls_Manager::DATE_TIME,
                'label'          => esc_html__( 'Countdown', 'moozo-elementor' ),
                'picker_options' => [
                    'dateFormat' => 'm/j/Y H:i:s',
                    'time_24hr'  => true,
                ],
            ]
        );

        $this->add_control(
            'days_text',
            [
                'type'  => Controls_Manager::TEXT,
                'label' => esc_html__( 'Days text', 'moozo-elementor' ),
            ]
        );

        $this->add_control(
            'hrs_text',
            [
                'type'  => Controls_Manager::TEXT,
                'label' => esc_html__( 'Hours text', 'moozo-elementor' ),
            ]
        );

        $this->add_control(
            'mins_text',
            [
                'type'  => Controls_Manager::TEXT,
                'label' => esc_html__( 'Minutes text', 'moozo-elementor' ),
            ]
        );

        $this->add_control(
            'secs_text',
            [
                'type'  => Controls_Manager::TEXT,
                'label' => esc_html__( 'Seconds text', 'moozo-elementor' ),
            ]
        );

        $this->add_responsive_control(
            'space',
            [
                'label'     => esc_html__( 'Space', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--count-space: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'divider_width',
            [
                'label'     => esc_html__( 'Divider width', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'default'   => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--divider-width: {{VALUE}}px;',
                ],
                'condition' => [
                    'space' => 0,
                ],
            ]
        );

        $this->add_control(
            'divider_color',
            [
                'label'     => esc_html__( 'Divider color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}}' => '--divider-color: {{VALUE}};',
                ],
                'condition' => [
                    'space' => 0,
                ],
            ]
        );

        $this->add_control(
            'text_inline',
            [
                'type'         => Controls_Manager::SWITCHER,
                'label'        => esc_html__( 'Text Inline', 'moozo-elementor' ),
                'prefix_class' => 'inline-',
            ]
        );

        $this->add_control(
            'vertical_align',
            [
                'type'      => Controls_Manager::SELECT,
                'label'     => esc_html__( 'Vertical Align', 'moozo-elementor' ),
                'options'   => [
                    'top'    => esc_html__( 'Top', 'moozo-elementor' ),
                    'middle' => esc_html__( 'Middle', 'moozo-elementor' ),
                    'bottom' => esc_html__( 'Bottom', 'moozo-elementor' ),
                ],
                'default'   => 'middle',
                'selectors' => [
                    '{{WRAPPER}}' => '--count-align: {{VALUE}};',
                ],
                'condition' => [
                    'text_inline' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'line_space',
            [
                'label'     => esc_html__( 'Number/Text Space', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--number-space: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'        => esc_html__( 'Alignment', 'moozo-elementor' ),
                'type'         => Controls_Manager::CHOOSE,
                'options'      => [
                    'left'    => [
                        'title' => esc_html__( 'Left', 'moozo-elementor' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center'  => [
                        'title' => esc_html__( 'Center', 'moozo-elementor' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'   => [
                        'title' => esc_html__( 'Right', 'moozo-elementor' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'moozo-elementor' ),
                        'icon'  => 'eicon-text-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'default'      => '',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'number_section',
            [
                'tab'   => Controls_Manager::TAB_STYLE,
                'label' => esc_html__( 'Number', 'moozo-elementor' ),
            ]
        );

        $this->add_responsive_control(
            'number_width',
            [
                'label'     => esc_html__( 'Min width', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--number-width: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'moozo-elementor' ),
                'name'     => 'number_typo',
                'scheme'   => Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .number',
            ]
        );

        $this->add_control(
            'number_color',
            [
                'label'     => esc_html__( 'Color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .number' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'number_bg',
            [
                'label'     => esc_html__( 'Background', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .number' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'number_space',
            [
                'label'      => esc_html__( 'Padding', 'moozo-elementor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .number' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'number_bdw',
            [
                'label'     => esc_html__( 'Border width', 'moozo-elementor' ),
                'type'      => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .number' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_control(
            'number_bdc',
            [
                'label'     => esc_html__( 'Border color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .number' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'number_bdr',
            [
                'label'      => esc_html__( 'Border radius', 'moozo-elementor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .number' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'text_section',
            [
                'tab'   => Controls_Manager::TAB_STYLE,
                'label' => esc_html__( 'Text', 'moozo-elementor' ),
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'moozo-elementor' ),
                'name'     => 'text_typo',
                'scheme'   => Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .text',
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label'     => esc_html__( 'Color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'text_space',
            [
                'label'      => esc_html__( 'Padding', 'moozo-elementor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        echo ovic_do_shortcode( $this->get_name(), $settings );
    }
}