<?php
if ( !defined( 'ABSPATH' ) ) {
    exit();
}

use Elementor\Core\Schemes;
use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Newsletter extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_newsletter';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__( 'Newsletter', 'moozo-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-yoast';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_section',
            array(
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__( 'General', 'moozo-elementor' ),
            )
        );

        $this->add_control(
            'form_id',
            [
                'type'        => Controls_Manager::SELECT,
                'label'       => esc_html__( 'Newsletter Form', 'moozo-elementor' ),
                'options'     => moozo_get_form_newsletter(),
                'default'     => '0',
                'description' => sprintf( '%s <a href="%s" target="_blank">%s</a>',
                    esc_html__( 'Add new form', 'moozo-elementor' ),
                    admin_url( 'admin.php?page=mailchimp-for-wp-forms&view=add-form' ),
                    esc_html__( 'Here!', 'moozo-elementor' )
                ),
            ]
        );

        $this->add_control(
            'one_line',
            [
                'label'        => esc_html__( 'All in one line', 'moozo-elementor' ),
                'type'         => Controls_Manager::SWITCHER,
                'prefix_class' => 'one-line-',
            ]
        );

        $this->add_control(
            'break_line',
            [
                'label'        => esc_html__( 'Break line', 'moozo-elementor' ),
                'type'         => Controls_Manager::SWITCHER,
                'prefix_class' => 'break-',
                'condition'    => [
                    'one_line!' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'break_line_mobile',
            [
                'label'        => esc_html__( 'Break line in mobile ( < 480px )', 'moozo-elementor' ),
                'type'         => Controls_Manager::SWITCHER,
                'default'      => 'yes',
                'condition'    => [
                    'break_line!' => 'yes',
                    'one_line!'   => 'yes',
                ],
                'prefix_class' => 'break-mobile-',
            ]
        );

        $this->add_control(
            'button_full_width',
            [
                'label'        => esc_html__( 'Button full width', 'moozo-elementor' ),
                'type'         => Controls_Manager::SWITCHER,
                'prefix_class' => 'button-full-',
                'condition'    => [
                    'one_line!' => 'yes',
                ],
                'conditions'   => [
                    'relation' => 'or',
                    'terms'    => [
                        [
                            'name'     => 'break_line',
                            'operator' => '==',
                            'value'    => 'yes',
                        ],
                        [
                            'name'     => 'break_line_mobile',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value'    => 'yes',
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'vertical_align',
            [
                'type'      => Controls_Manager::SELECT,
                'label'     => esc_html__( 'Vertical Align', 'moozo-elementor' ),
                'options'   => [
                    'flex-start' => esc_html__( 'Top', 'moozo-elementor' ),
                    'center'     => esc_html__( 'Middle', 'moozo-elementor' ),
                    'flex-end'   => esc_html__( 'Bottom', 'moozo-elementor' ),
                ],
                'selectors' => [
                    '{{WRAPPER}}' => '--vertical-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'        => esc_html__( 'Alignment', 'moozo-elementor' ),
                'type'         => Controls_Manager::CHOOSE,
                'options'      => [
                    'left'    => [
                        'title' => esc_html__( 'Left', 'moozo-elementor' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center'  => [
                        'title' => esc_html__( 'Center', 'moozo-elementor' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'   => [
                        'title' => esc_html__( 'Right', 'moozo-elementor' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'moozo-elementor' ),
                        'icon'  => 'eicon-text-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'default'      => '',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'input_section',
            [
                'tab'   => Controls_Manager::TAB_STYLE,
                'label' => esc_html__( 'Input', 'moozo-elementor' ),
            ]
        );

        $this->add_control(
            'placeholder',
            [
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__( 'Your e-mail address', 'moozo-elementor' ),
                'label_block' => true,
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'moozo-elementor' ),
                'name'     => 'input_typo',
                'scheme'   => Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .input-text[type]',
            ]
        );

        $this->add_control(
            'input_color',
            [
                'label'     => esc_html__( 'Color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .text-field' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'input_bg',
            [
                'label'     => esc_html__( 'Background', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .text-field' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'space',
            [
                'label'     => esc_html__( 'Space', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--input-space: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'input_order',
            [
                'label'     => esc_html__( 'Order', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}}' => '--input-order: {{VALUE}};',
                ],
                'condition'    => [
                    'one_line' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'input_width',
            [
                'label'     => esc_html__( 'Min width', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--input-width: {{VALUE}}px;',
                ],
                'condition'    => [
                    'one_line' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'input_space',
            [
                'label'      => esc_html__( 'Padding', 'moozo-elementor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .input-text[type]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'input_bdw',
            [
                'label'     => esc_html__( 'Border width', 'moozo-elementor' ),
                'type'      => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .input-focus' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_control(
            'input_bdc',
            [
                'label'     => esc_html__( 'Border color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .input-focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'input_bdr',
            [
                'label'      => esc_html__( 'Border radius', 'moozo-elementor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .text-field' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_section',
            [
                'tab'   => Controls_Manager::TAB_STYLE,
                'label' => esc_html__( 'Button', 'moozo-elementor' ),
            ]
        );

        $this->add_control(
            'button_type',
            [
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__( 'Type', 'moozo-elementor' ),
                'options' => [
                    'text' => esc_html__( 'Text', 'moozo-elementor' ),
                    'icon' => esc_html__( 'icon', 'moozo-elementor' ),
                ],
                'default' => 'text',
            ]
        );

        $this->add_control(
            'button',
            [
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__( 'Subscribe', 'moozo-elementor' ),
                'label_block' => true,
                'condition'   => [
                    'button_type' => 'text',
                ],
            ]
        );

        $this->add_control(
            'button_icon',
            [
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'far fa-paper-plane',
                    'library' => 'fa-regular',
                ],
                'condition'        => [
                    'button_type' => 'icon',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'moozo-elementor' ),
                'name'     => 'button_typo',
                'scheme'   => Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .submit-newsletter',
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label'     => esc_html__( 'Color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .submit-newsletter' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg',
            [
                'label'     => esc_html__( 'Background', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .submit-newsletter' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'button_margin',
            [
                'label'     => esc_html__( 'Space', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--button-space: {{VALUE}}px;',
                ],
                'condition'    => [
                    'one_line' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_order',
            [
                'label'     => esc_html__( 'Order', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}}' => '--button-order: {{VALUE}};',
                ],
                'condition'    => [
                    'one_line' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_space',
            [
                'label'      => esc_html__( 'Padding', 'moozo-elementor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .submit-newsletter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_bdw',
            [
                'label'     => esc_html__( 'Border width', 'moozo-elementor' ),
                'type'      => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .submit-newsletter' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_control(
            'button_bdc',
            [
                'label'     => esc_html__( 'Border color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .submit-newsletter' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_bdr',
            [
                'label'      => esc_html__( 'Border radius', 'moozo-elementor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .submit-newsletter' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'checkbox_section',
            [
                'tab'   => Controls_Manager::TAB_STYLE,
                'label' => esc_html__( 'Checkbox', 'moozo-elementor' ),
            ]
        );

        $this->start_controls_tabs( 'checkbox_general' );

        $this->start_controls_tab(
            'checkbox_text',
            [
                'label' => esc_html__( 'Text', 'moozo-elementor' ),
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'moozo-elementor' ),
                'name'     => 'text_typo',
                'scheme'   => Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .checkbox',
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label'     => esc_html__( 'Color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .checkbox' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'text_margin',
            [
                'label'     => esc_html__( 'Space', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--checkbox-space: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'checkbox_order',
            [
                'label'     => esc_html__( 'Order', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}}' => '--checkbox-order: {{VALUE}};',
                ],
                'condition'    => [
                    'one_line' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'checkbox',
            [
                'type'        => Controls_Manager::WYSIWYG,
                'label_block' => true,
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'checkbox_box',
            [
                'label' => esc_html__( 'Box', 'moozo-elementor' ),
            ]
        );

        $this->add_control(
            'box_color',
            [
                'label'     => esc_html__( 'Color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .checkbox-focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'box_bg',
            [
                'label'     => esc_html__( 'Background', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .checkbox-focus' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_margin',
            [
                'label'     => esc_html__( 'Space', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'default'   => 10,
                'selectors' => [
                    '{{WRAPPER}} .checkbox-focus' => 'margin-inline-end: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_control(
            'box_icon',
            [
                'label'            => esc_html__( 'Icon', 'moozo-elementor' ),
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'main-icon-check1',
                    'library' => 'main-icon',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_font_size',
            [
                'label'     => esc_html__( 'Font Size', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'default'   => 9,
                'selectors' => [
                    '{{WRAPPER}} .checkbox-focus' => 'font-size: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_size',
            [
                'label'     => esc_html__( 'Size', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}} .checkbox-focus' => 'width: {{VALUE}}px; height: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_space',
            [
                'label'     => esc_html__( 'Padding', 'moozo-elementor' ),
                'type'      => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .checkbox-focus > *' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_bdw',
            [
                'label'     => esc_html__( 'Border width', 'moozo-elementor' ),
                'type'      => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .checkbox-focus' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_control(
            'box_bdc',
            [
                'label'     => esc_html__( 'Border color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .checkbox-focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_bdr',
            [
                'label'      => esc_html__( 'Border radius', 'moozo-elementor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .checkbox-focus' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        echo ovic_do_shortcode( $this->get_name(), $settings );
    }
}