<?php
if ( !defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Newsletter"
 * @version 1.0.0
 */
class Shortcode_Ovic_Newsletter extends Ovic_Addon_Shortcode
{
    /**
     * Shortcode name.
     *
     * @var  string
     */
    public $shortcode = 'ovic_newsletter';
    public $default   = array(
        'button_type' => 'text',
    );

    public function newsletter_form( $html, $form_id )
    {
        if ( function_exists( 'mc4wp_show_form' ) ) {
            $api_key = mc4wp_get_api_key();
            if ( empty( $api_key ) ) {
                echo sprintf( '<div class="alert alert-warning"><strong>%s</strong> <a href="' . esc_url( 'https://wordpress.org/plugins/mailchimp-for-wp/' ) . '">%s</a></div>',
                    esc_html__( 'Warning!', 'moozo-elementor' ),
                    esc_html__( 'API key is empty.', 'moozo-elementor' )
                );
            }
            if ( $form_id == get_option( 'mc4wp_default_form_id', '0' ) ) {
                add_filter( 'mc4wp_form_content',
                    function ( $content, $form, $element ) use ( $html ) {
                        return $html;
                    }, 10, 3
                );
                mc4wp_show_form( $form_id );
                remove_all_filters( 'mc4wp_form_content' );
            } else {
                mc4wp_show_form( $form_id );
            }
        } else {
            echo sprintf( '<div class="alert alert-warning"><strong>%s</strong> <a href="' . esc_url( 'https://wordpress.org/plugins/mailchimp-for-wp/' ) . '">%s</a></div>',
                esc_html__( 'Warning!', 'moozo-elementor' ),
                esc_html__( 'Please Active plugin "Mailchimp for WordPress".', 'moozo-elementor' )
            );
        }
    }

    public function content( $atts, $content = null )
    {
        $css_class = $this->main_class( $atts, array(
            'ovic-newsletter'
        ) );
        $form_id   = get_option( 'mc4wp_default_form_id', '0' );
        if ( !empty( $atts['form_id'] ) ) {
            $form_id = $atts['form_id'];
        }
        ob_start();
        ?>
        <div class="<?php echo esc_attr( $css_class ); ?>">
            <?php ob_start(); ?>
            <label class="text-field field-email">
                <input class="input-text email-newsletter" type="email" name="EMAIL"
                       required="required"
                       placeholder="<?php echo esc_html( $atts['placeholder'] ); ?>">
                <span class="input-focus"></span>
            </label>
            <?php if ( $atts['button_type'] == 'text' && !empty( $atts['button'] ) ): ?>
                <button type="submit" class="submit-newsletter" value="">
                    <?php echo esc_html( $atts['button'] ); ?>
                </button>
            <?php endif; ?>
            <?php if ( $atts['button_type'] == 'icon' && !empty( $atts['button_icon']['value'] ) ): ?>
                <button type="submit" class="submit-newsletter" value="">
                    <?php if ( !empty( $atts['box_icon']['value'] ) ) {
                        \Elementor\Icons_Manager::render_icon( $atts['button_icon'], [ 'aria-hidden' => 'true' ] );
                    } ?>
                </button>
            <?php endif; ?>
            <?php if ( !empty( $atts['checkbox'] ) ) : ?>
                <div class="checkbox">
                    <label>
                        <input name="AGREE_TO_TERMS" type="checkbox" value="1" required="">
                        <span class="checkbox-focus">
                        <?php if ( !empty( $atts['box_icon']['value'] ) ) {
                            \Elementor\Icons_Manager::render_icon( $atts['box_icon'], [ 'aria-hidden' => 'true' ] );
                        } ?>
                    </span>
                        <?php echo wp_specialchars_decode( $atts['checkbox'] ); ?>
                    </label>
                </div>
            <?php endif;
            $html = ob_get_clean();
            $this->newsletter_form( $html, $form_id );
            ?>
        </div>
        <?php
        return ob_get_clean();
    }
}