<?php

class Editor_Ovic_Products
{
    public static function shortcode_config()
    {
        return array(
            'name'   => 'ovic_products',
            'title'  => 'Products',
            'fields' => array(
                'title'         => array(
                    'id'    => 'title',
                    'type'  => 'text',
                    'title' => esc_html__('Title', 'moozo-elementor'),
                ),
                'list_style'    => array(
                    'id'      => 'list_style',
                    'type'    => 'text',
                    'class'   => 'ovic-hidden',
                    'default' => 'none',
                    'title'   => esc_html__('List style', 'moozo-elementor'),
                ),
                'product_style' => array(
                    'id'          => 'product_style',
                    'type'        => 'select_preview',
                    'title'       => esc_html__('Product style', 'moozo-elementor'),
                    'options'     => moozo_product_options('Shortcode'),
                    'default'     => 'style-01',
                    'description' => esc_html__('Select a style for product item', 'moozo-elementor'),
                ),
                'target'        => array(
                    'id'          => 'target',
                    'type'        => 'select',
                    'title'       => esc_html__('Target', 'moozo-elementor'),
                    'options'     => array(
                        'recent_products'       => esc_html__('Recent Products', 'moozo-elementor'),
                        'featured_products'     => esc_html__('Feature Products', 'moozo-elementor'),
                        'sale_products'         => esc_html__('Sale Products', 'moozo-elementor'),
                        'best_selling_products' => esc_html__('Best Selling Products', 'moozo-elementor'),
                        'top_rated_products'    => esc_html__('Top Rated Products', 'moozo-elementor'),
                        'products'              => esc_html__('Products', 'moozo-elementor'),
                        'product_category'      => esc_html__('Products Category', 'moozo-elementor'),
                        'related_products'      => esc_html__('Products Related', 'moozo-elementor'),
                    ),
                    'attributes'  => array(
                        'data-depend-id' => 'target',
                    ),
                    'default'     => 'recent_products',
                    'description' => esc_html__('Choose the target to filter products', 'moozo-elementor'),
                ),
                'ids'           => array(
                    'id'          => 'ids',
                    'type'        => 'select',
                    'chosen'      => true,
                    'multiple'    => true,
                    'sortable'    => true,
                    'ajax'        => true,
                    'options'     => 'posts',
                    'query_args'  => array(
                        'post_type' => 'product',
                    ),
                    'title'       => esc_html__('Products', 'moozo-elementor'),
                    'description' => esc_html__('Enter List of Products', 'moozo-elementor'),
                    'dependency'  => array('target', '==', 'products'),
                ),
                'category'      => array(
                    'id'          => 'category',
                    'type'        => 'select',
                    'chosen'      => true,
                    'ajax'        => true,
                    'options'     => 'categories',
                    'placeholder' => esc_html__('Select Products Category', 'moozo-elementor'),
                    'query_args'  => array(
                        'hide_empty' => true,
                        'taxonomy'   => 'product_cat',
                    ),
                    'title'       => esc_html__('Product Categories', 'moozo-elementor'),
                    'description' => esc_html__('Note: If you want to narrow output, select category(s) above. Only selected categories will be displayed.',
                        'moozo-elementor'),
                    'dependency'  => array('target', '!=', 'products'),
                ),
                'limit'         => array(
                    'id'          => 'limit',
                    'type'        => 'number',
                    'unit'        => 'items(s)',
                    'default'     => '6',
                    'title'       => esc_html__('Limit', 'moozo-elementor'),
                    'description' => esc_html__('How much items per page to show', 'moozo-elementor'),
                ),
                'orderby'       => array(
                    'id'          => 'orderby',
                    'type'        => 'select',
                    'title'       => esc_html__('Order by', 'moozo-elementor'),
                    'options'     => array(
                        ''              => esc_html__('None', 'moozo-elementor'),
                        'date'          => esc_html__('Date', 'moozo-elementor'),
                        'ID'            => esc_html__('ID', 'moozo-elementor'),
                        'author'        => esc_html__('Author', 'moozo-elementor'),
                        'title'         => esc_html__('Title', 'moozo-elementor'),
                        'modified'      => esc_html__('Modified', 'moozo-elementor'),
                        'rand'          => esc_html__('Random', 'moozo-elementor'),
                        'comment_count' => esc_html__('Comment count', 'moozo-elementor'),
                        'menu_order'    => esc_html__('Menu order', 'moozo-elementor'),
                        'price'         => esc_html__('Price: low to high', 'moozo-elementor'),
                        'price-desc'    => esc_html__('Price: high to low', 'moozo-elementor'),
                        'rating'        => esc_html__('Average Rating', 'moozo-elementor'),
                        'popularity'    => esc_html__('Popularity', 'moozo-elementor'),
                        'post__in'      => esc_html__('Post In', 'moozo-elementor'),
                        'most-viewed'   => esc_html__('Most Viewed', 'moozo-elementor'),
                    ),
                    'description' => sprintf(esc_html__('Select how to sort retrieved products. More at %s.',
                        'moozo-elementor'),
                        '<a href="'.esc_url('http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters').'" target="_blank">'.esc_html__('WordPress codex page',
                            'moozo-elementor').'</a>'),
                ),
                'order'         => array(
                    'id'          => 'order',
                    'type'        => 'select',
                    'title'       => esc_html__('Sort order', 'moozo-elementor'),
                    'options'     => array(
                        ''     => esc_html__('None', 'moozo-elementor'),
                        'DESC' => esc_html__('Descending', 'moozo-elementor'),
                        'ASC'  => esc_html__('Ascending', 'moozo-elementor'),
                    ),
                    'description' => sprintf(esc_html__('Designates the ascending or descending order. More at %s.',
                        'moozo-elementor'),
                        '<a href="'.esc_url('http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters').'" target="_blank">'.esc_html__('WordPress codex page',
                            'moozo-elementor').'</a>'),
                ),
            ),
        );
    }
}