<?php
if (!defined('ABSPATH')) {
    exit();
}

use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Products extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_products';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Products', 'moozo-elementor');
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-woocommerce';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_section',
            array(
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__('General', 'moozo-elementor'),
            )
        );

        $this->start_controls_tabs('tabs_general');

        $this->start_controls_tab(
            'tab_general',
            [
                'label' => esc_html__('Settings', 'moozo-elementor'),
            ]
        );

        $this->add_control(
            'list_style',
            array(
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__('List style', 'moozo-elementor'),
                'options' => [
                    'none' => esc_html__('None', 'moozo-elementor'),
                    'grid' => esc_html__('Bootstrap', 'moozo-elementor'),
                    'owl'  => esc_html__('Carousel', 'moozo-elementor'),
                ],
                'default' => 'owl',
            )
        );

        $this->add_control(
            'product_style',
            array(
                'type'        => Controls_Manager::SELECT,
                'label'       => esc_html__('Product style', 'moozo-elementor'),
                'options'     => moozo_product_options('Shortcode', true),
                'default'     => 'style-01',
                'description' => esc_html__('Select a style for product item', 'moozo-elementor'),
            )
        );

        $this->product_size_field();

        $this->add_control(
            'disable_labels',
            [
                'label' => esc_html__('Disable Labels', 'moozo-elementor'),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'disable_rating',
            [
                'label' => esc_html__('Disable Rating', 'moozo-elementor'),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'short_text',
            [
                'label'       => esc_html__('Short Title', 'moozo-elementor'),
                'description' => esc_html__('Cut title by css to one line.', 'moozo-elementor'),
                'type'        => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'overflow_visible',
            [
                'label' => esc_html__('Content Overflow', 'moozo-elementor'),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_products',
            [
                'label' => esc_html__('Products', 'moozo-elementor'),
            ]
        );

        $this->add_control(
            'pagination',
            [
                'label'   => esc_html__('Pagination', 'moozo-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'none'      => esc_html__('None', 'moozo-elementor'),
                    'view_all'  => esc_html__('View all', 'moozo-elementor'),
                    'load_more' => esc_html__('Load More', 'moozo-elementor'),
                    'infinite'  => esc_html__('Infinite Scrolling', 'moozo-elementor'),
                ],
                'default' => 'none',
            ]
        );

        $this->add_control(
            'link',
            [
                'type'        => Controls_Manager::URL,
                'label'       => esc_html__('Link', 'moozo-elementor'),
                'placeholder' => esc_html__('https://your-link.com', 'moozo-elementor'),
                'default'     => [
                    'url' => '#',
                ],
                'condition'   => [
                    'pagination' => 'view_all',
                ],
            ]
        );

        $this->add_control(
            'text_button',
            [
                'type'      => Controls_Manager::TEXT,
                'label'     => esc_html__('Text button', 'moozo-elementor'),
                'default'   => 'VIEW ALL',
                'condition' => [
                    'pagination' => 'view_all',
                ],
            ]
        );

        $this->add_control(
            'target',
            [
                'label'   => esc_html__('Target', 'moozo-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'recent_products'       => esc_html__('Recent Products', 'moozo-elementor'),
                    'featured_products'     => esc_html__('Feature Products', 'moozo-elementor'),
                    'sale_products'         => esc_html__('Sale Products', 'moozo-elementor'),
                    'best_selling_products' => esc_html__('Best Selling Products', 'moozo-elementor'),
                    'top_rated_products'    => esc_html__('Top Rated Products', 'moozo-elementor'),
                    'products'              => esc_html__('Products', 'moozo-elementor'),
                    'product_category'      => esc_html__('Products Category', 'moozo-elementor'),
                    'related_products'      => esc_html__('Products Related', 'moozo-elementor'),
                ],
                'default' => 'recent_products',
            ]
        );

        if (class_exists('ElementorPro\Modules\QueryControl\Module')) {
            $this->add_control(
                'ids',
                [
                    'label'        => esc_html__('Search Product', 'moozo-elementor'),
                    'type'         => ElementorPro\Modules\QueryControl\Module::QUERY_CONTROL_ID,
                    'options'      => [],
                    'label_block'  => true,
                    'multiple'     => true,
                    'autocomplete' => [
                        'object' => ElementorPro\Modules\QueryControl\Module::QUERY_OBJECT_POST,
                        'query'  => [
                            'post_type' => 'product'
                        ],
                    ],
                    'condition'    => [
                        'target' => 'products'
                    ],
                    'export'       => false,
                ]
            );
        } else {
            $this->add_control(
                'ids',
                [
                    'label'       => esc_html__('Product', 'moozo-elementor'),
                    'type'        => Controls_Manager::TEXT,
                    'description' => esc_html__('Product ids', 'moozo-elementor'),
                    'placeholder' => '1,2,3',
                    'label_block' => true,
                    'condition'   => [
                        'target' => 'products'
                    ],
                ]
            );
        }

        $this->add_control(
            'category',
            [
                'label'       => esc_html__('Products Category', 'moozo-elementor'),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_taxonomy([
                    'hide_empty' => true,
                    'taxonomy'   => 'product_cat',
                ]),
                'label_block' => true,
                'condition'   => [
                    'target!' => 'products'
                ],
            ]
        );

        $this->add_control(
            'limit',
            [
                'label'       => esc_html__('Limit', 'moozo-elementor'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 6,
                'placeholder' => 6,
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label'   => esc_html__('Order by', 'moozo-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ''              => esc_html__('None', 'moozo-elementor'),
                    'date'          => esc_html__('Date', 'moozo-elementor'),
                    'ID'            => esc_html__('ID', 'moozo-elementor'),
                    'author'        => esc_html__('Author', 'moozo-elementor'),
                    'title'         => esc_html__('Title', 'moozo-elementor'),
                    'modified'      => esc_html__('Modified', 'moozo-elementor'),
                    'rand'          => esc_html__('Random', 'moozo-elementor'),
                    'comment_count' => esc_html__('Comment count', 'moozo-elementor'),
                    'menu_order'    => esc_html__('Menu order', 'moozo-elementor'),
                    'price'         => esc_html__('Price: low to high', 'moozo-elementor'),
                    'price-desc'    => esc_html__('Price: high to low', 'moozo-elementor'),
                    'rating'        => esc_html__('Average Rating', 'moozo-elementor'),
                    'popularity'    => esc_html__('Popularity', 'moozo-elementor'),
                    'post__in'      => esc_html__('Post In', 'moozo-elementor'),
                    'most-viewed'   => esc_html__('Most Viewed', 'moozo-elementor'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label'   => esc_html__('Sort order', 'moozo-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ''     => esc_html__('None', 'moozo-elementor'),
                    'DESC' => esc_html__('Descending', 'moozo-elementor'),
                    'ASC'  => esc_html__('Ascending', 'moozo-elementor'),
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'carousel_section',
            [
                'tab'       => Controls_Manager::TAB_SETTINGS,
                'label'     => esc_html__('Carousel settings', 'moozo-elementor'),
                'condition' => [
                    'list_style' => 'owl',
                ],
            ]
        );

        $this->add_control(
            'slide_nav',
            [
                'label'   => esc_html__('Nav style', 'moozo-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => moozo_nav_style(),
                'default' => '',
            ]
        );

        $this->carousel_settings(false);

        $this->end_controls_section();

        $this->bootstrap_settings([
            'tab'       => Controls_Manager::TAB_SETTINGS,
            'label'     => esc_html__('Bootstrap settings', 'moozo-elementor'),
            'condition' => [
                'list_style' => 'grid',
            ],
        ]);
    }

    protected function render()
    {
        $settings        = $this->get_settings_for_display();
        $settings['_id'] = substr($this->get_id_int(), 0, 3);

        echo ovic_do_shortcode($this->get_name(), $settings);
    }
}