<?php
if (!defined('ABSPATH')) {
    exit();
}

use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Review extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_review';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Review', 'moozo-elementor');
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-product-categories';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_section',
            array(
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__('General', 'moozo-elementor'),
            )
        );

        $this->add_control(
            'style',
            [
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__('Select style', 'moozo-elementor'),
                'options' => moozo_preview_options('ovic_review'),
                'default' => 'style-01',
            ]
        );

        $this->add_control(
            'post_type',
            [
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__('Post Type', 'moozo-elementor'),
                'options' => moozo_get_post_type(),
                'default' => 'post',
            ]
        );

        $this->add_control(
            'orderby',
            [
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__('Order by', 'moozo-elementor'),
                'options' => [
                    'comment_agent'        => esc_html__('Agent', 'moozo-elementor'),
                    'comment_approved'     => esc_html__('Approved', 'moozo-elementor'),
                    'comment_author'       => esc_html__('Author', 'moozo-elementor'),
                    'comment_author_email' => esc_html__('Author Email', 'moozo-elementor'),
                    'comment_author_ip'    => esc_html__('Author IP', 'moozo-elementor'),
                    'comment_author_url'   => esc_html__('Author Url', 'moozo-elementor'),
                    'comment_ID'           => esc_html__('Comment ID', 'moozo-elementor'),
                    'comment_karma'        => esc_html__('Comment Karma', 'moozo-elementor'),
                    'comment_parent'       => esc_html__('Comment Parent', 'moozo-elementor'),
                    'comment_type'         => esc_html__('Comment Type', 'moozo-elementor'),
                    'comment_date_gmt'     => esc_html__('Date GMT', 'moozo-elementor'),
                    'comment_date'         => esc_html__('Date', 'moozo-elementor'),
                    'comment_post_ID'      => esc_html__('Post ID', 'moozo-elementor'),
                    'user_id'              => esc_html__('User ID', 'moozo-elementor'),
                ],
                'default' => 'comment_date_gmt',
            ]
        );

        $this->add_control(
            'order',
            [
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__('Order', 'moozo-elementor'),
                'options' => [
                    'DESC' => esc_html__('DESC', 'moozo-elementor'),
                    'ASC'  => esc_html__('ASC', 'moozo-elementor'),
                ],
                'default' => 'DESC',
            ]
        );

        $this->add_control(
            'number',
            [
                'type'    => Controls_Manager::NUMBER,
                'label'   => esc_html__('Number', 'moozo-elementor'),
                'default' => 6,
            ]
        );

        $this->add_responsive_control(
            'space',
            [
                'label'      => esc_html__('Padding', 'moozo-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .review-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'border_radius',
            [
                'label'      => esc_html__('Border Radius', 'moozo-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .review-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'carousel_section',
            [
                'tab'   => Controls_Manager::TAB_SETTINGS,
                'label' => esc_html__('Carousel settings', 'moozo-elementor'),
            ]
        );

        $this->add_control(
            'slide_nav',
            [
                'label'   => esc_html__('Nav style', 'moozo-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => moozo_nav_style(),
                'default' => '',
            ]
        );

        $this->carousel_settings(false);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (!empty($settings['text_button'])) {
            $this->add_render_attribute('_wrapper', 'class', 'has-button');
        }

        echo ovic_do_shortcode($this->get_name(), $settings);
    }
}