<?php
if ( !defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Review"
 * @version 1.0.0
 */
class Shortcode_Ovic_Review extends Ovic_Addon_Shortcode
{
    /**
     * Shortcode name.
     *
     * @var  string
     */
    public $shortcode = 'ovic_review';
    public $default   = array(
        'style'             => 'style-01',
        'slides_rows_space' => '',
        'slide_nav'         => '',
    );

    public function content( $atts, $content = null )
    {
        $css_class    = $this->main_class( $atts,
            array(
                'ovic-review',
                $atts['style'],
                $atts['slides_rows_space'],
                $atts['slide_nav']
            )
        );
        $owl_settings = $this->generate_carousel( $atts );
        ob_start();
        $args     = array(
            'post_type'   => $atts['post_type'],
            'post_status' => 'publish',
            'orderby'     => $atts['orderby'],
            'order'       => $atts['order'],
            'number'      => $atts['number'],
        );
        $comments = get_comments( $args );
        ?>
        <div class="<?php echo esc_attr( $css_class ); ?>">
            <div class="review-inner owl-slick" <?php echo esc_attr( $owl_settings ); ?>>
                <?php if ( !empty( $comments ) ): ?>
                    <?php foreach ( $comments as $comment ): ?>
                        <div class="review-item">
                            <?php
                            if ( $atts['post_type'] == 'product' ) {
                                $rating = intval( get_comment_meta( $comment->comment_ID, 'rating', true ) );
                                echo wc_get_rating_html( $rating );
                            }
                            ?>
                            <p class="desc">
                                <a href="<?php echo get_comment_link( $comment ); ?>">
                                    <?php echo wp_trim_words( wp_specialchars_decode( $comment->comment_content ), 15, esc_html__( '...', 'moozo-elementor' ) ); ?>
                                </a>
                            </p>
                            <div class="meta">
                                <div class="avatar"><?php echo get_avatar( $comment, 35 ); ?></div>
                                <div class="author"><?php echo get_comment_author_link( $comment ); ?></div>
                                <div class="date"><?php echo esc_html( get_comment_date( 'd F Y', $comment ) ); ?></div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
}