<?php
if ( !defined( 'ABSPATH' ) ) {
    exit();
}

use Elementor\Core\Schemes;
use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Tabs extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_tabs';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__( 'Tabs', 'moozo-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-product-tabs';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_section',
            [
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__( 'General', 'moozo-elementor' ),
            ]
        );

        $this->start_controls_tabs( 'tabs_general' );

        $this->start_controls_tab(
            'tab_general',
            [
                'label' => esc_html__( 'Settings', 'moozo-elementor' ),
            ]
        );

        $this->add_control(
            'active',
            [
                'label'   => esc_html__( 'Active', 'moozo-elementor' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 1,
                'min'     => 1,
            ]
        );

        $this->add_control(
            'is_ajax',
            [
                'label' => esc_html__( 'Enable ajax', 'moozo-elementor' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'tab_vertical',
            [
                'type'         => Controls_Manager::SWITCHER,
                'label'        => esc_html__( 'Vertical', 'moozo-elementor' ),
                'prefix_class' => 'vertical-',
            ]
        );

        $this->add_control(
            'tab_align',
            [
                'type'      => Controls_Manager::SELECT,
                'label'     => esc_html__( 'Vertical Align ( >= 768px )', 'moozo-elementor' ),
                'options'   => [
                    'flex-start' => esc_html__( 'Top', 'moozo-elementor' ),
                    'center'     => esc_html__( 'Middle', 'moozo-elementor' ),
                    'flex-end'   => esc_html__( 'Bottom', 'moozo-elementor' ),
                ],
                'selectors' => [
                    '{{WRAPPER}}' => '--tab-align: {{VALUE}};',
                ],
                'condition' => [
                    'tab_vertical' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_width',
            [
                'label'     => esc_html__( 'Width', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--tab-width: {{VALUE}}px;',
                ],
                'condition' => [
                    'tab_vertical' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'space',
            [
                'label'     => esc_html__( 'Space', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--tab-space: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'     => esc_html__( 'Alignment', 'moozo-elementor' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'    => [
                        'title' => esc_html__( 'Left', 'moozo-elementor' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center'  => [
                        'title' => esc_html__( 'Center', 'moozo-elementor' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'   => [
                        'title' => esc_html__( 'Right', 'moozo-elementor' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'moozo-elementor' ),
                        'icon'  => 'eicon-text-align-justify',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tabs-head' => 'text-align: {{VALUE}};',
                ],
                'default'   => '',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_product',
            [
                'label' => esc_html__( 'Product Settings', 'moozo-elementor' ),
            ]
        );

        $this->add_control(
            'product_style',
            array(
                'type'        => Controls_Manager::SELECT,
                'label'       => esc_html__( 'Product style', 'moozo-elementor' ),
                'options'     => moozo_product_options( 'Shortcode', true ),
                'default'     => 'style-01',
                'description' => esc_html__( 'Select a style for product item', 'moozo-elementor' ),
            )
        );

        $this->product_size_field();

        $this->add_control(
            'disable_labels',
            [
                'label' => esc_html__( 'Disable Labels', 'moozo-elementor' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'disable_rating',
            [
                'label' => esc_html__( 'Disable Rating', 'moozo-elementor' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'short_text',
            [
                'label'       => esc_html__( 'Short Title', 'moozo-elementor' ),
                'description' => esc_html__( 'Cut title by css to one line.', 'moozo-elementor' ),
                'type'        => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'overflow_visible',
            [
                'label' => esc_html__( 'Content Overflow', 'moozo-elementor' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'tab_section',
            [
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__( 'Tab Content', 'moozo-elementor' ),
            ]
        );

        $repeater = new Elementor\Repeater();

        $repeater->start_controls_tabs( 'tab_repeater' );

        $repeater->start_controls_tab(
            'tab_title',
            [
                'label' => esc_html__( 'Title', 'moozo-elementor' ),
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label'       => esc_html__( 'Title', 'moozo-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__( 'Tab Title', 'moozo-elementor' ),
                'placeholder' => esc_html__( 'Tab Title', 'moozo-elementor' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'content',
            [
                'label'   => esc_html__( 'Content', 'moozo-elementor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'product'  => esc_html__( 'Products', 'moozo-elementor' ),
                    'template' => esc_html__( 'Template', 'moozo-elementor' ),
                    'link'     => esc_html__( 'Simple Link', 'moozo-elementor' ),
                ],
                'default' => 'product',
            ]
        );

        $repeater->add_control(
            'selected_media',
            [
                'label'   => esc_html__( 'Media', 'moozo-elementor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'image' => esc_html__( 'Image', 'moozo-elementor' ),
                    'icon'  => esc_html__( 'Icon', 'moozo-elementor' ),
                ],
                'default' => 'image',
            ]
        );

        $repeater->add_control(
            'selected_icon',
            [
                'label'            => esc_html__( 'Icon', 'moozo-elementor' ),
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'condition'        => [
                    'selected_media' => 'icon'
                ],
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label'     => esc_html__( 'Image', 'moozo-elementor' ),
                'type'      => Controls_Manager::MEDIA,
                'condition' => [
                    'selected_media' => 'image'
                ],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label'       => esc_html__( 'Link', 'moozo-elementor' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'moozo-elementor' ),
                'default'     => [
                    'url' => '#',
                ],
                'condition'   => [
                    'content' => 'link',
                ],
            ]
        );

        $repeater->end_controls_tab();

        $repeater->start_controls_tab(
            'tab_template',
            [
                'label'     => esc_html__( 'Template', 'moozo-elementor' ),
                'condition' => [
                    'content' => 'template',
                ],
            ]
        );

        if ( class_exists( 'ElementorPro\Modules\QueryControl\Module' ) ) {
            $repeater->add_control(
                'template_id',
                [
                    'label'        => esc_html__( 'Template ID', 'moozo-elementor' ),
                    'type'         => ElementorPro\Modules\QueryControl\Module::QUERY_CONTROL_ID,
                    'options'      => [],
                    'label_block'  => true,
                    'multiple'     => false,
                    'autocomplete' => [
                        'object' => ElementorPro\Modules\QueryControl\Module::QUERY_OBJECT_POST,
                        'query'  => [
                            'post_type' => 'elementor_library'
                        ],
                    ],
                    'description'  => sprintf( '%s <a href="%s" target="_blank">%s</a>',
                        esc_html__( 'Create template from', 'moozo-elementor' ),
                        admin_url( 'edit.php?post_type=elementor_library&tabs_group=library' ),
                        esc_html__( 'Here', 'moozo-elementor' )
                    ),
                    'export'       => false,
                ]
            );
        } else {
            $repeater->add_control(
                'template_id',
                [
                    'label'       => esc_html__( 'Template ID', 'moozo-elementor' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => '1',
                    'description' => sprintf( '%s <a href="%s" target="_blank">%s</a>',
                        esc_html__( 'Create template from', 'moozo-elementor' ),
                        admin_url( 'edit.php?post_type=elementor_library&tabs_group=library' ),
                        esc_html__( 'Here', 'moozo-elementor' )
                    ),
                ]
            );
        }

        $repeater->end_controls_tab();

        $repeater->start_controls_tab(
            'tab_product',
            [
                'label'     => esc_html__( 'Product', 'moozo-elementor' ),
                'condition' => [
                    'content' => 'product',
                ],
            ]
        );

        $repeater->add_control(
            'target',
            [
                'label'   => esc_html__( 'Target', 'moozo-elementor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'recent_products'       => esc_html__( 'Recent Products', 'moozo-elementor' ),
                    'featured_products'     => esc_html__( 'Feature Products', 'moozo-elementor' ),
                    'sale_products'         => esc_html__( 'Sale Products', 'moozo-elementor' ),
                    'best_selling_products' => esc_html__( 'Best Selling Products', 'moozo-elementor' ),
                    'top_rated_products'    => esc_html__( 'Top Rated Products', 'moozo-elementor' ),
                    'products'              => esc_html__( 'Products', 'moozo-elementor' ),
                    'product_category'      => esc_html__( 'Products Category', 'moozo-elementor' ),
                    'related_products'      => esc_html__( 'Products Related', 'moozo-elementor' ),
                ],
                'default' => 'recent_products',
            ]
        );

        if ( class_exists( 'ElementorPro\Modules\QueryControl\Module' ) ) {
            $repeater->add_control(
                'ids',
                [
                    'label'        => esc_html__( 'Search Product', 'moozo-elementor' ),
                    'type'         => ElementorPro\Modules\QueryControl\Module::QUERY_CONTROL_ID,
                    'options'      => [],
                    'label_block'  => true,
                    'multiple'     => true,
                    'autocomplete' => [
                        'object' => ElementorPro\Modules\QueryControl\Module::QUERY_OBJECT_POST,
                        'query'  => [
                            'post_type' => 'product'
                        ],
                    ],
                    'condition'    => [
                        'target' => 'products'
                    ],
                    'export'       => false,
                ]
            );
        } else {
            $repeater->add_control(
                'ids',
                [
                    'label'       => esc_html__( 'Product', 'moozo-elementor' ),
                    'type'        => Controls_Manager::TEXT,
                    'description' => esc_html__( 'Product ids', 'moozo-elementor' ),
                    'placeholder' => '1,2,3',
                    'label_block' => true,
                    'condition'   => [
                        'target' => 'products'
                    ],
                ]
            );
        }

        $repeater->add_control(
            'category',
            [
                'label'       => esc_html__( 'Products Category', 'moozo-elementor' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_taxonomy( [
                    'hide_empty' => true,
                    'taxonomy'   => 'product_cat',
                ] ),
                'label_block' => true,
                'condition'   => [
                    'target!' => 'products'
                ],
            ]
        );

        $repeater->add_control(
            'limit',
            [
                'label'       => esc_html__( 'Limit', 'moozo-elementor' ),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 6,
                'placeholder' => 6,
            ]
        );

        $repeater->add_control(
            'orderby',
            [
                'label'   => esc_html__( 'Order by', 'moozo-elementor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ''              => esc_html__( 'None', 'moozo-elementor' ),
                    'date'          => esc_html__( 'Date', 'moozo-elementor' ),
                    'ID'            => esc_html__( 'ID', 'moozo-elementor' ),
                    'author'        => esc_html__( 'Author', 'moozo-elementor' ),
                    'title'         => esc_html__( 'Title', 'moozo-elementor' ),
                    'modified'      => esc_html__( 'Modified', 'moozo-elementor' ),
                    'rand'          => esc_html__( 'Random', 'moozo-elementor' ),
                    'comment_count' => esc_html__( 'Comment count', 'moozo-elementor' ),
                    'menu_order'    => esc_html__( 'Menu order', 'moozo-elementor' ),
                    'price'         => esc_html__( 'Price: low to high', 'moozo-elementor' ),
                    'price-desc'    => esc_html__( 'Price: high to low', 'moozo-elementor' ),
                    'rating'        => esc_html__( 'Average Rating', 'moozo-elementor' ),
                    'popularity'    => esc_html__( 'Popularity', 'moozo-elementor' ),
                    'post__in'      => esc_html__( 'Post In', 'moozo-elementor' ),
                    'most-viewed'   => esc_html__( 'Most Viewed', 'moozo-elementor' ),
                ],
            ]
        );

        $repeater->add_control(
            'order',
            [
                'label'   => esc_html__( 'Sort order', 'moozo-elementor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ''     => esc_html__( 'None', 'moozo-elementor' ),
                    'DESC' => esc_html__( 'Descending', 'moozo-elementor' ),
                    'ASC'  => esc_html__( 'Ascending', 'moozo-elementor' ),
                ],
            ]
        );

        $repeater->end_controls_tab();

        $repeater->end_controls_tabs();

        $this->add_control(
            'tabs',
            [
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'tab_list_section',
            [
                'tab'   => Controls_Manager::TAB_STYLE,
                'label' => esc_html__( 'Tab List', 'moozo-elementor' ),
            ]
        );

        $this->add_control(
            'tab_list_bg',
            [
                'label'     => esc_html__( 'Background', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tabs-head' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_list_space',
            [
                'label'      => esc_html__( 'Padding', 'moozo-elementor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .tabs-head' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_list_bdw',
            [
                'label'     => esc_html__( 'Border width', 'moozo-elementor' ),
                'type'      => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .tabs-head' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_control(
            'tab_list_bdc',
            [
                'label'     => esc_html__( 'Border color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tabs-head' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_list_bdr',
            [
                'label'      => esc_html__( 'Border radius', 'moozo-elementor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .tabs-head' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_list_margin',
            [
                'label'     => esc_html__( 'Space', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--list-space: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_list_divider',
            [
                'label'     => esc_html__( 'Divider width', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--divider-width: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_control(
            'tab_list_divider_color',
            [
                'label'     => esc_html__( 'Divider color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}}' => '--divider-color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'tab_item_section',
            [
                'tab'   => Controls_Manager::TAB_STYLE,
                'label' => esc_html__( 'Tab Item', 'moozo-elementor' ),
            ]
        );

        $this->start_controls_tabs( 'tabs_item' );

        $this->start_controls_tab(
            'tab_item_normal',
            [
                'label' => esc_html__( 'Normal', 'moozo-elementor' ),
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'moozo-elementor' ),
                'name'     => 'tab_item_typo',
                'scheme'   => Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .tab-item a',
            ]
        );

        $this->add_control(
            'tab_item_color',
            [
                'label'     => esc_html__( 'Color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tab-item a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tab_item_bg',
            [
                'label'     => esc_html__( 'Background', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tab-item a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_item_space',
            [
                'label'      => esc_html__( 'Padding', 'moozo-elementor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .tab-item a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_item_bdw',
            [
                'label'     => esc_html__( 'Border width', 'moozo-elementor' ),
                'type'      => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .tab-item a' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_control(
            'tab_item_bdc',
            [
                'label'     => esc_html__( 'Border color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tab-item a' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_item_bdr',
            [
                'label'      => esc_html__( 'Border radius', 'moozo-elementor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .tab-item a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_item_active',
            [
                'label' => esc_html__( 'Active', 'moozo-elementor' ),
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'moozo-elementor' ),
                'name'     => 'tab_item_typo_active',
                'scheme'   => Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .tab-item.active a,{{WRAPPER}} .tab-item a:hover',
            ]
        );

        $this->add_control(
            'tab_item_color_active',
            [
                'label'     => esc_html__( 'Color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tab-item.active a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tab-item a:hover'  => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tab_item_bg_active',
            [
                'label'     => esc_html__( 'Background', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tab-item.active a' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .tab-item a:hover'  => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tab_item_bdc_active',
            [
                'label'     => esc_html__( 'Border color', 'moozo-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Schemes\Color::get_type(),
                    'value' => Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tab-item.active a' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .tab-item a:hover'  => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'tab_icon_section',
            [
                'tab'   => Controls_Manager::TAB_STYLE,
                'label' => esc_html__( 'Tab Icon', 'moozo-elementor' ),
            ]
        );

        $this->add_control(
            'tab_icon_size',
            [
                'label'     => esc_html__( 'Size', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--icon-size: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_control(
            'tab_icon_space',
            [
                'label'     => esc_html__( 'Space', 'moozo-elementor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}}' => '--icon-space: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_control(
            'tab_icon_break',
            [
                'type'         => Controls_Manager::SWITCHER,
                'label'        => esc_html__( 'Break line', 'moozo-elementor' ),
                'default'      => 'yes',
                'prefix_class' => 'icon-break-',
            ]
        );

        $this->add_control(
            'tab_icon_align',
            [
                'type'      => Controls_Manager::SELECT,
                'label'     => esc_html__( 'Vertical Align', 'moozo-elementor' ),
                'options'   => [
                    'top'    => esc_html__( 'Top', 'moozo-elementor' ),
                    'middle' => esc_html__( 'Middle', 'moozo-elementor' ),
                    'bottom' => esc_html__( 'Bottom', 'moozo-elementor' ),
                ],
                'default'   => 'middle',
                'selectors' => [
                    '{{WRAPPER}} .tab-item a > *' => 'vertical-align: {{VALUE}};',
                ],
                'condition' => [
                    'tab_icon_break!' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'carousel_section',
            [
                'tab'   => Controls_Manager::TAB_STYLE,
                'label' => esc_html__( 'Carousel settings', 'moozo-elementor' ),
            ]
        );

        $this->add_control(
            'slide_nav',
            [
                'label'   => esc_html__( 'Nav style', 'moozo-elementor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => moozo_nav_style(),
                'default' => '',
            ]
        );

        $this->carousel_settings( false );

        $this->end_controls_section();
    }
}