<?php
/**
 * Template Blog Related
 */
?>
<?php
global $post;
$page_layout     = moozo_page_layout();
$enable_related  = moozo_get_option( 'enable_related_post' );
$related_title   = moozo_get_option( 'related_post_title' );
$related_perpage = moozo_get_option( 'related_post_perpage', 6 );
$categories      = get_the_category( $post->ID );
$item            = 3;
if ( $page_layout['layout'] == 'left' || $page_layout['layout'] == 'right' ) {
    $item = 2;
}
if ( $categories && $enable_related == 1 ) : ?>
    <?php
    $data_slick   = array(
        'infinite'     => false,
        'slidesToShow' => $item,
        'slidesMargin' => 10,
        'arrows'       => false,
        'responsive'   => array(
            array(
                'breakpoint' => 992,
                'settings'   => array(
                    'slidesToShow' => 2,
                ),
            ),
            array(
                'breakpoint' => 480,
                'settings'   => array(
                    'slidesToShow' => 1,
                ),
            ),
        ),
    );
    $category_ids = array();
    foreach ( $categories as $value ) {
        $category_ids[] = $value->term_id;
    }
    $args      = array(
        'category__in'        => $category_ids,
        'post__not_in'        => array( $post->ID ),
        'posts_per_page'      => $related_perpage,
        'ignore_sticky_posts' => 1,
        'orderby'             => 'rand',
    );
    $new_query = new wp_query( $args );
    if ( $new_query->have_posts() ) : ?>
        <div class="related-post">
            <?php if ( $page_layout['layout'] != 'left' && $page_layout['layout'] != 'right' ) {
                echo '<div class="container">';
            } ?>
            <?php if ( !empty( $related_title ) ) : ?>
                <h3 class="related-title"><?php echo wp_specialchars_decode( $related_title ); ?></h3>
            <?php endif; ?>
            <div class="owl-slick" data-slick="<?php echo esc_attr( json_encode( $data_slick ) ); ?>">
                <?php while ( $new_query->have_posts() ): $new_query->the_post(); ?>
                    <?php
                    $width  = 410;
                    $height = 260;
                    ?>
                    <article <?php post_class( array( 'post-item' ) ); ?>>
                        <div class="post-inner">
                            <?php
                            moozo_post_thumbnail( $width, $height );
                            moozo_post_title();
                            moozo_post_date();
                            ?>
                        </div>
                    </article>
                <?php endwhile; ?>
            </div>
            <?php if ( $page_layout['layout'] != 'left' && $page_layout['layout'] != 'right' ) {
                echo '</div>';
            } ?>
        </div>
    <?php else :
        echo '<div class="related-post no-item"></div>';
    endif;
    wp_reset_postdata();
else :
    echo '<div class="related-post no-item"></div>';
endif;