<?php
/**
 * Template Blog Sticky
 */
?>
<?php
$enable_sticky = moozo_get_option( 'enable_blog_sticky' );
$blog_sticky   = moozo_get_option( 'blog_sticky' );
if ( $enable_sticky == 1 && !empty( $blog_sticky ) ) : ?>
    <?php
    $data_slick   = array(
        'infinite'      => true,
        'slidesToShow'  => 1,
        'speed'         => 1000,
        'autoplay'      => true,
        'autoplaySpeed' => 3000,
        'arrows'        => false,
    );
    $args         = array(
        'post_type'           => 'post',
        'post_status'         => 'publish',
        'post__in'            => $blog_sticky,
        'ignore_sticky_posts' => 1,
        'posts_per_page'      => -1,
        'orderby'             => 'post__in',
    );
    $sticky_query = new WP_Query( $args );
    if ( $sticky_query->have_posts() ) : ?>
        <div class="sticky-post">
            <div class="owl-slick" data-slick="<?php echo esc_attr( json_encode( $data_slick ) ); ?>">
                <?php while ( $sticky_query->have_posts() ): $sticky_query->the_post(); ?>
                    <article <?php post_class( 'post-item style-01' ); ?>>
                        <div class="post-inner">
                            <?php moozo_post_thumbnail_simple(); ?>
                            <div class="post-info">
                                <?php
                                moozo_post_date();
                                moozo_post_title();
                                moozo_post_excerpt( 25 );
                                moozo_post_readmore();
                                ?>
                            </div>
                        </div>
                    </article>
                <?php endwhile; ?>
                <?php wp_reset_postdata() ?>
            </div>
        </div>
    <?php endif;
endif;
