<?php
$vertical_menu   = moozo_theme_option_meta(
    '_custom_metabox_theme_options',
    'vertical_menu',
    'metabox_vertical_menu'
);
$vertical_title  = moozo_theme_option_meta(
    '_custom_metabox_theme_options',
    'vertical_title',
    'metabox_vertical_title'
);
$vertical_height = moozo_theme_option_meta(
    '_custom_metabox_theme_options',
    'vertical_height',
    'metabox_vertical_height'
);
$always_open     = moozo_get_option( 'vertical_always_open' );
$classes         = 'box-nav-vertical moozo-dropdown';
if ( !empty( $always_open ) && is_page() && is_array( $always_open ) && in_array( $id, $always_open ) ) {
    $classes .= ' always-open';
}
if ( !empty( $vertical_menu ) ) : ?>
    <div class="header-vertical">
        <div class=" <?php echo esc_attr( $classes ); ?>">
            <?php if ( !empty( $vertical_title ) ) : ?>
                <a href="#" data-moozo="moozo-dropdown" class="block-title">
                    <span class="icon main-icon-menu"></span>
                    <span class="text"><?php echo esc_html( $vertical_title ); ?></span>
                </a>
            <?php endif; ?>
            <div class="block-content sub-menu" style="<?php if ( !empty( $vertical_height ) ) echo '--min-height: ' . esc_attr( $vertical_height ) . 'px;'; ?>">
                <?php
                wp_nav_menu(
                    array(
                        'menu'            => $vertical_menu,
                        'theme_location'  => $vertical_menu,
                        'container'       => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'megamenu'        => true,
                        'mobile_enable'   => true,
                        'menu_class'      => 'moozo-nav vertical-menu',
                        'megamenu_layout' => 'vertical',
                    )
                );
                ?>
            </div>
        </div>
    </div>
<?php endif;