<?php
/**
 * Name: Blog Grid
 **/
?>
<?php
$page_layout   = moozo_page_layout();
$main_skin     = moozo_get_skin();
$container     = moozo_theme_option_meta(
    '_custom_metabox_theme_options',
    'main_container',
    'metabox_main_container'
);
$sidebar_width = 0;
$sidebar_space = 0;
$columns       = 3;
$blog_space    = 5;
$crop          = 0.631;
if ( $page_layout['layout'] == 'left' || $page_layout['layout'] == 'right' ) {
    $sidebar_width = moozo_get_option( 'sidebar_width', 270 );
    $sidebar_space = moozo_get_option( 'sidebar_space', 30 );
    $columns       = 2;
}
if ( $main_skin == 'tools-orange' ) {
    $blog_space = 10;
}
if ( $main_skin == 'fashion' ) {
    $crop = 0.73;
}
$width  = ( $container - $sidebar_width - $sidebar_space - ( ( $columns - 1 ) * ( $blog_space * 2 ) ) ) / $columns;
$height = $width * $crop;
?>
<div class="blog-content blog-grid response-content"
     style="--blog-columns: <?php echo esc_attr( $columns ); ?>; --blog-space: <?php echo esc_attr( $blog_space ); ?>px;">
    <?php while ( have_posts() ): the_post(); ?>
        <article <?php post_class( 'post-item style-02' ); ?>>
            <div class="post-inner">
                <?php moozo_post_thumbnail( $width, $height ); ?>
                <div class="post-info">
                    <?php
                    moozo_post_title();
                    moozo_post_excerpt( 14 );
                    moozo_post_date();
                    ?>
                </div>
            </div>
        </article>
    <?php endwhile; ?>
</div>
<?php moozo_post_pagination(); ?>
