<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
    echo get_the_password_form(); // WPCS: XSS ok.

    return;
}

if ( function_exists( 'ovic_set_post_views' ) ) {
    ovic_set_post_views( $product->get_id(), 'product' );
}

$single_product_style = moozo_get_option( 'single_product_style', 'style-01' );
$hook                 = array(
    array( 'remove_action', 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 ),
    array( 'add_action', 'woocommerce_product_thumbnails', 'moozo_more_product_thumbnails', 30 ),
    array( 'remove_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 ),
    array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_meta', 10 ),
    array( 'add_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 ),
    array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_delivery', 12 ),
    array( 'remove_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 ),
    array( 'add_action', 'woocommerce_single_product_summary', 'moozo_product_loop_countdown', 20 ),
    array( 'add_action', 'woocommerce_single_product_summary', 'moozo_process_availability', 20 ),
    array( 'remove_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 ),
    array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_add_image', 90 ),
    array( 'add_action', 'woocommerce_single_product_summary', 'moozo_product_share', 95 )
);
if ( $single_product_style == 'style-01' )
    array_push( $hook,
        array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_categories', 0 ),
        array( 'remove_action', 'woocommerce_single_product_summary', 'moozo_single_product_meta', 10 ),
        array( 'remove_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 ),
        array( 'add_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 10 ),
        array( 'add_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 ),
        array( 'remove_action', 'woocommerce_single_product_summary', 'moozo_process_availability', 20 ),
        array( 'add_action', 'woocommerce_single_product_summary', 'moozo_process_availability', 10 )
    );
if ( $single_product_style == 'style-06' || $single_product_style == 'style-08' || $single_product_style == 'style-09' )
    array_push( $hook,
        array(
            'add_action', 'woocommerce_single_product_summary', function () {
            echo '<div class="product_meta-top">';
        }, 0
        ),
        array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_categories', 0 ),
        array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_flash_stock', 0 ),
        array(
            'add_action', 'woocommerce_single_product_summary', function () {
            echo '</div>';
        }, 0
        )
    );
if ( $single_product_style == 'style-02' || $single_product_style == 'style-05' )
    array_push( $hook,
        array(
            'add_action', 'woocommerce_single_product_summary', function () {
            echo '<div class="product_meta-top">';
        }, 0
        ),
        array( 'add_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 0 ),
        array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_flash_stock', 0 ),
        array(
            'add_action', 'woocommerce_single_product_summary', function () {
            echo '</div>';
        }, 0
        ),
        array( 'remove_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 ),
        array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_categories', 0 )
    );
if ( $single_product_style == 'style-03' )
    array_push( $hook,
        array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_flash_stock', 0 ),
        array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_categories', 5 ),
        array( 'remove_action', 'woocommerce_single_product_summary', 'moozo_single_product_meta', 10 )
    );
if ( $single_product_style == 'style-04' )
    array_push( $hook,
        array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_flash_stock', 0 ),
        array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_categories', 0 ),
        array( 'remove_action', 'woocommerce_single_product_summary', 'moozo_single_product_add_image', 90 ),
        array( 'remove_action', 'woocommerce_single_product_summary', 'moozo_product_share', 95 ),
        array( 'add_action', 'moozo_after_single_product_summary', 'moozo_single_product_add_image', 0 ),
        array( 'add_action', 'moozo_after_single_product_summary', 'moozo_product_share', 0 )
    );
if ( $single_product_style == 'style-05' || $single_product_style == 'style-06' )
    array_push( $hook,
        array( 'remove_action', 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 ),
        array( 'add_action', 'woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs', 90 )
    );
if ( $single_product_style == 'style-06' )
    array_push( $hook,
        array( 'remove_action', 'woocommerce_single_product_summary', 'moozo_product_share', 95 ),
        array( 'add_action', 'woocommerce_after_single_product_summary', 'moozo_product_share', 10 )
    );
if ( $single_product_style == 'style-07' )
    array_push( $hook,
        array( 'add_action', 'woocommerce_before_single_product_summary', 'moozo_single_product_flash_stock', 0 ),
        array( 'add_action', 'woocommerce_before_single_product_summary', 'woocommerce_template_single_title', 0 ),
        array( 'add_action', 'woocommerce_before_single_product_summary', 'moozo_single_product_categories', 0 ),
        array( 'add_action', 'woocommerce_before_single_product_summary', 'woocommerce_template_single_rating', 0 ),
        array( 'remove_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 ),
        array( 'remove_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 ),
        array( 'remove_action', 'woocommerce_single_product_summary', 'moozo_single_product_meta', 10 )
    );
if ( $single_product_style == 'style-08' )
    array_push( $hook,
        array( 'remove_action', 'woocommerce_single_product_summary', 'moozo_single_product_delivery', 12 ),
        array( 'remove_action', 'woocommerce_single_product_summary', 'moozo_single_product_add_image', 90 ),
        array( 'add_action', 'woocommerce_single_product_summary', 'moozo_single_product_delivery', 90 ),
        array( 'add_action', 'moozo_after_single_product_summary', 'moozo_single_product_add_iconbox', 0 ),
        array( 'add_action', 'moozo_after_single_product_summary', 'moozo_single_product_add_image', 0 )
    );
moozo_add_action( $hook );
$attachment_ids = $product->get_gallery_image_ids();
$class_wrapper  = array( 'single-product-wrapper' );
$class_summary  = array( 'summary entry-summary' );
if ( !empty( $attachment_ids ) && has_post_thumbnail() || !empty( $video_url ) || !empty( $galleries ) ) {
    $class_wrapper[] = 'has-gallery';
}
if ( !empty( $attachment_ids ) && $single_product_style == 'style-05' ) {
    wp_enqueue_script( 'moozo-sticky' );
    $class_wrapper[] = 'wrapper-main-content';
    $class_summary[] = 'sticky-content';
}
$vertical       = false;
$style_vertical = array( 'style-01', 'style-02', 'style-04', 'style-09' );
if ( in_array( $single_product_style, $style_vertical ) ) {
    $vertical = true;
}
$slide      = apply_filters( 'moozo_slide_single_product_thumbnail', array(
    'infinite'        => false,
    'slidesMargin'    => 10,
    'slidesToShow'    => 4,
    'vertical'        => $vertical,
    'verticalSwiping' => $vertical,
    'responsive'      => array(
        array(
            'breakpoint' => 480,
            'settings'   => array(
                'vertical'        => false,
                'verticalSwiping' => false,
            ),
        ),
    ),
) );
$data_slide = json_encode( $slide );
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>

    <div class="<?php echo esc_attr( implode( ' ', $class_wrapper ) ); ?>"
         data-slick="<?php echo esc_attr( $data_slide ); ?>">
        <?php
        /**
         * Hook: woocommerce_before_single_product_summary.
         *
         * @hooked woocommerce_show_product_sale_flash - 10
         * @hooked woocommerce_show_product_images - 20
         */
        do_action( 'woocommerce_before_single_product_summary' );
        ?>

        <div class="<?php echo esc_attr( implode( ' ', $class_summary ) ); ?>">
            <div class="inner-summary">
                <?php
                /**
                 * Hook: woocommerce_single_product_summary.
                 *
                 * @hooked woocommerce_template_single_title - 5
                 * @hooked woocommerce_template_single_rating - 10
                 * @hooked woocommerce_template_single_price - 10
                 * @hooked woocommerce_template_single_excerpt - 20
                 * @hooked woocommerce_template_single_add_to_cart - 30
                 * @hooked woocommerce_template_single_meta - 40
                 * @hooked woocommerce_template_single_sharing - 50
                 * @hooked WC_Structured_Data::generate_product_data() - 60
                 */
                do_action( 'woocommerce_single_product_summary' );
                ?>
            </div>
            <div class="after-summary">
                <?php do_action( 'moozo_after_single_product_summary' ); ?>
            </div>
        </div>
    </div>

    <?php
    /**
     * Hook: woocommerce_after_single_product_summary.
     *
     * @hooked woocommerce_output_product_data_tabs - 10
     * @hooked woocommerce_upsell_display - 15
     * @hooked woocommerce_output_related_products - 20
     */
    do_action( 'woocommerce_after_single_product_summary' );
    ?>
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>

<?php moozo_add_action( $hook, true ); ?>
