<!DOCTYPE html>
<html lang="fa">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="description" content="Kanotek Calculator and Order Wizard">
	<meta name="author" content="Kanotek.ir">
	<title>محاسبه گر | هزینه پروفیل درب و پنجره</title>

	<!-- Favicon -->
	<link href="img/favicon.ico" rel="shortcut icon">

	<!-- Google Fonts - Poppins, Karla -->
	<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Karla:300,400,500,600,700" rel="stylesheet">

	<!-- Font Awesome CSS -->
	<link href="vendor/fontawesome/css/all.min.css" rel="stylesheet">

	<!-- Custom Font Icons -->
	<link href="vendor/icomoon/css/iconfont.min.css" rel="stylesheet">

	<!-- Vendor CSS -->
	<link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
	<link href="vendor/animate/css/animate.min.css" rel="stylesheet">
	<link href="vendor/dmenu/css/menu.css" rel="stylesheet">
	<link href="vendor/hamburgers/css/hamburgers.min.css" rel="stylesheet">
	<link href="vendor/mmenu/css/mmenu.min.css" rel="stylesheet">
	<link href="vendor/range-slider/css/ion.rangeSlider.css" rel="stylesheet">
	<link href="vendor/magnific-popup/css/magnific-popup.css" rel="stylesheet">
	<link href="vendor/float-labels/css/float-labels.min.css" rel="stylesheet">

	<!-- Main CSS -->
	<link href="css/style.css" rel="stylesheet">

</head>

<body>

	<!-- Preloader -->
	<div id="preloader">
		<div data-loader="circle-side"></div>
	</div>
	<!-- Preloader End -->

	<!-- Page -->
	<div id="page">
		<!-- Header -->
		<header class="main-header sticky">
			<a href="#menu" class="btn-mobile">
				<div class="hamburger hamburger--spin" id="hamburger">
					<div class="hamburger-box">
						<div class="hamburger-inner"></div>
					</div>
				</div>
			</a>
			<div class="container">
				<div class="row">
					<div class="col-lg-3 col-6">
						<div id="logo">
							<h1><a href="index.php" title="Kanotek"> </a></h1>
						</div>
					</div>
					<div class="col-lg-9 col-6">
						<ul id="menuIcons">
							<li><a href="#"><i class="icon icon-support"></i></a></li>
							<li><a href="#"><i class="icon icon-shopping-cart2"></i></a></li>
						</ul>
						<!-- Menu -->
						<nav id="menu" class="main-menu">
							<ul>
								<li><span><a href="index.php">خانه</a></span></li>
								<li><span><a href="#">راهنمای محاسبه گر</a></span></li>
								<li><span><a href="calculator-2.php">محاسبه گر</a></span></li>
								<li><span><a href="contacts.php">تماس با ما</a></span></li>
							</ul>
						</nav>
						<!-- Menu End -->
					</div>
				</div>
			</div>
		</header>
		<!-- Header End -->

		<!-- Sub Header -->
		<div class="sub-header">
			<div class="container">
				<h1>محاسبه گر هزینه پروفیل</h1>
			</div>
		</div>
		<!-- Sub Header End -->

		<main>
			<!-- Order  -->
			<div class="order">
				<div class="container">
					<!-- Form -->
					<form method="POST" id="orderForm" name="orderForm" action="php/send_order_2_attached_pdf.php">
						<div class="row">
							<div class="col-lg-8" id="mainContent">
								<!-- Calculator Area -->
								<div id="optionGroup1" class="row option-box">
									<div class="price-box"><sup> ريال </sup>1025.64</div>
									<div class="option-box-header">
										<h3>کانوتک اکو</h3>
										<p>
										
											ابعاد پروفیل خود را وارد نمایید ( طول و عرض به سانتی متر )
											
										</p>
									</div>
									<div class="col-md-6 col-sm-6">
										<input type="hidden" id="option1Title" name="option1Title" value="Single Option 1" />
										<input type="hidden" id="option1Price" name="option1Price" value="0" />
										<input type="checkbox" id="option1Single" class="inp-cbx" name="option1Single" value="1025.64" />
										<label class="cbx" for="option1Single">
											<span>
												<svg width="12px" height="10px" viewbox="0 0 12 10">
													<polyline points="1.5 6 4.5 9 10.5 1"></polyline>
												</svg>
											</span>
											<span id="option1SingleTitle">انتخاب پروفیل اکو</span>
										</label>
									</div>
									<div class="col-md-6 col-sm-6">
										<div class="row">
											<div class="col-8">
												<input id="option1SingleRangeSlider" type="text" value="" />
											</div>
											<div class="col-4">
												<input id="option1SingleQty" type="text" class="qty-input form-control" name="optionGroup1Qty" value="0" />
											</div>
										</div>
									</div>
								</div>
								<div id="optionGroup2" class="row option-box">
									<div class="ribbon-left"><span class="left">پیشنهاد ویژه</span></div>
									<div class="price-box"><sup> ريال </sup>103.63</div>
									<div class="option-box-header">
										<h3>کانوتک گرین</h3>
										<p>
											ابعاد پروفیل خود را وارد نمایید ( طول و عرض به سانتی متر )
											
										</p>
									</div>
									<div class="col-md-6 col-sm-6">
										<input type="hidden" id="option2Title" name="option2Title" value="Single Option 2" />
										<input type="hidden" id="option2Price" name="option2Price" value="0" />
										<input type="checkbox" id="option2Single" class="inp-cbx" name="option2Single" value="103.63" />
										<label class="cbx" for="option2Single">
											<span>
												<svg width="12px" height="10px" viewbox="0 0 12 10">
													<polyline points="1.5 6 4.5 9 10.5 1"></polyline>
												</svg>
											</span>
											<span id="option2SingleTitle">انتخاب پروفیل گرین</span>
										</label>
									</div>
									<div class="col-md-6 col-sm-6">
										<div class="row">
											<div class="col-8">
												<input id="option2SingleRangeSlider" type="text" value="" />
											</div>
											<div class="col-4">
												<input id="option2SingleQty" type="text" class="qty-input form-control" name="optionGroup2Qty" value="0" />
											</div>
										</div>
									</div>
								</div>
								<div id="optionGroup3" class="row option-box">
									<div class="price-box"><sup> ريال </sup>10.75</div>
									<div class="option-box-header">
										<h3>کانوتک پلاس</h3>
										<p>ابعاد پروفیل خود را وارد نمایید ( طول و عرض به سانتی متر )</p>
									</div>
									<div class="col-md-6 col-sm-6">
										<input type="hidden" id="option3Title" name="option3Title" value="Single Option 3" />
										<input type="hidden" id="option3Price" name="option3Price" value="0" />
										<input type="checkbox" id="option3Single" class="inp-cbx" name="option3Single" value="10.75" />
										<label class="cbx" for="option3Single">
											<span>
												<svg width="12px" height="10px" viewbox="0 0 12 10">
													<polyline points="1.5 6 4.5 9 10.5 1"></polyline>
												</svg>
											</span>
											<span id="option3SingleTitle">انتخاب پروفیل پلاس</span>
										</label>
									</div>
									<div class="col-md-6 col-sm-6">
										<div class="row">
											<div class="col-8">
												<input id="option3SingleRangeSlider" type="text" value="" />
											</div>
											<div class="col-4">
												<input id="option3SingleQty" type="text" class="qty-input form-control" name="optionGroup3Qty" value="0" />
											</div>
										</div>
									</div>
								</div>
								<div id="extraOptionGroup1" class="row option-box">
									<div class="price-box"><sup> ريال </sup>50</div>
									<div class="option-box-header">
										<h3>دوجداره</h3>
										<p>نوع شیشه درب / پنجره </p>
									</div>
									<div class="col-md-12 col-sm-12">
										<input type="hidden" name="extraOption1Title" value="Extra Option 1" />
										<input type="checkbox" id="extraOption1" class="inp-cbx" name="extraOption1" value="50.00" />
										<label class="cbx" for="extraOption1">
											<span>
												<svg width="12px" height="10px" viewbox="0 0 12 10">
													<polyline points="1.5 6 4.5 9 10.5 1"></polyline>
												</svg>
											</span>
											<span id="extraOption1Title">انتخاب شیشه دوجداراه</span>
										</label>
									</div>
								</div>
								<div id="extraOptionGroup2" class="row option-box">
									<div class="price-box"><sup> ريال </sup>70</div>
									<div class="option-box-header">
										<h3>سه جداره</h3>
										<p>نوع شیشه درب / پنجره </p>
									</div>
									<div class="col-md-12 col-sm-12">
										<input type="hidden" name="extraOption2Title" value="Extra Option 2" />
										<input type="checkbox" id="extraOption2" class="inp-cbx" name="extraOption2" value="70.00" />
										<label class="cbx" for="extraOption2">
											<span>
												<svg width="12px" height="10px" viewbox="0 0 12 10">
													<polyline points="1.5 6 4.5 9 10.5 1"></polyline>
												</svg>
											</span>
											<span id="extraOption2Title">انتخاب شیشه سه جداره</span>
										</label>
									</div>
								</div>
								<div id="extraOptionGroup3" class="row option-box">
									<div class="price-box"><sup> ريال </sup>80</div>
									<div class="option-box-header">
										<h3>پروفیل ایرانی</h3>
										<p>نوع پروفیل درب / پنجره</p>
									</div>
									<div class="col-md-12 col-sm-12">
										<input type="hidden" name="extraOption3Title" value="Extra Option 3" />
										<input type="checkbox" id="extraOption3" class="inp-cbx" name="extraOption3" value="80.00" />
										<label class="cbx" for="extraOption3">
											<span>
												<svg width="12px" height="10px" viewbox="0 0 12 10">
													<polyline points="1.5 6 4.5 9 10.5 1"></polyline>
												</svg>
											</span>
											<span id="extraOption3Title">انتخاب پروفیل ایرانی</span>
										</label>
									</div>
								</div>
								<!-- Calculator Area End -->
								<!-- Personal Details --
								<div id="personalDetails" class="row contact-box">
									<div class="contact-box-header">
										<h3>راه ارتباط</h3>
										<p>پس از تایید اطلاعات برای شما ایمیل خواهد شد</p>
									</div>
									<div class="col-md-6 col-sm-6">
										<div class="form-group">
											<label for="userName">نام شما</label>
											<input id="userName" class="form-control" name="username" type="text" data-parsley-pattern="^[a-zA-Z\s.]+$" required />
										</div>
									</div>
									<div class="col-md-6 col-sm-6">
										<div class="form-group">
											<label for="email">ایمیل</label>
											<input id="email" class="form-control" name="email" type="email" required />
										</div>
									</div>
									<div class="col-md-6 col-sm-6">
										<div class="form-group">
											<label for="phone">تلفن همراه / ثابت</label>
											<input id="phone" class="form-control" name="phone" type="text" data-parsley-pattern="^\+{1}[0-9]+$" />
										</div>
									</div>
									<div class="col-md-6 col-sm-6">
										<div class="form-group">
											<label for="address">آدرس پستی</label>
											<input id="address" class="form-control" name="address" type="text" data-parsley-pattern="^[,.a-zA-Z0-9\s.]+$" />
										</div>
									</div>
									<div class="col-md-12">
										<div class="form-group">
											<label for="inputMessage">متن پیام</label>
											<textarea class="form-control" id="inputMessage" name="message" data-parsley-pattern="^[a-zA-Z0-9\s.:,!?']+$"></textarea>
										</div>
									</div>
								</div>
								<!-- Personal Details End -->
							</div>
							<div class="col-lg-4" id="sidebar">
								<!-- Order Container -->
								<div id="orderContainer" class="theiaStickySidebar">
									<div class="row">
										<div class="col-md-12">
											<input type="hidden" id="subSum1" name="subSum1" value="0" />
											<input type="hidden" id="subSum2" name="subSum2" value="0" />
											<input type="hidden" id="subSum3" name="subSum3" value="0" />
											<input type="hidden" id="totalDue" name="totalDue" value="0" />
											<h3>شرح هزینه ها</h3>
											<ul id="orderSumList">
												<li id="option1SingleSum"></li>
												<li id="option2SingleSum"></li>
												<li id="option3SingleSum"></li>
												<li id="extraOption1Sum"></li>
												<li id="extraOption2Sum"></li>
												<li id="extraOption3Sum"></li>
											</ul>
											<div class="row total-container">
												<div class="col-6 p-0">
													<input type="text" id="totalTitle" class="summaryInput" name="totallabel" value="" disabled />
												</div>
												<div class="col-6 p-0">
													<input type="text" id="total" class="summaryInput" name="total" value="0" data-parsley-errors-container="#totalError" data-parsley-empty-order=""
														disabled />
												</div>
											</div>
											<div id="totalError"></div>
										</div>
									</div>
									<div class="row">
										<div class="col-md-12">
											<div class="form-group">
												<input type="checkbox" id="cbx" class="inp-cbx" name="terms" value="yes" required />
												<label class="cbx terms" for="cbx">
													<span>
														<svg width="12px" height="10px" viewbox="0 0 12 10">
															<polyline points="1.5 6 4.5 9 10.5 1"></polyline>
														</svg>
													</span>
													<span>تایید اطلاعات و  <a href="#" class="terms-link" target="_blank"> ثبت سفارش </a>.</span>
												</label>
											</div>
										</div>
									</div>
									<div class="row">
										<div class="col-lg-12">
											<!--<button type="submit" name="submit" class="btn-form-func">
												<span class="btn-form-func-content">ثبت سفارش</span>
												<span class="icon"><i class="fa fa-check" aria-hidden="true"></i></span>
											</button>-->
										</div>
									</div>
									<div class="row">
										<div class="col-lg-12">
											<button type="button" name="reset" id="resetBtn" class="btn-form-func btn-form-func-alt-color">
												<span class="btn-form-func-content">پاک کردن</span>
												<span class="icon"><i class="fa fa-times" aria-hidden="true"></i></span>
											</button>
										</div>
									</div>
									<div class="row footer">
										<div class="col-lg-12 text-center">
											<small>&copy; 2023 Kanotek</small>
										</div>
									</div>
								</div>
								<!-- Order Container End -->
							</div>
						</div>
					</form>
					<!-- Form End -->
				</div>
			</div>
			<!-- Order End -->
		</main>
		<!-- Main End -->

		<!-- Footer -->
		<footer class="main-footer">
			<div class="container">
				<div class="row">
					<div class="col-md-4">
						<h5 class="footer-heading">تماس با ما</h5>
						<ul class="list-unstyled contact-links">
							<li><i class="icon icon-map-marker"></i><a href="#" class="footer-link" target="_blank">آدرس: تهران جردن بابک بهرامی پلاک 18</a>
							</li>
							<li><i class="icon icon-envelope3"></i><a href="mailto:info@kanotek.ir" class="footer-link">ایمیل: info@kanotek.ir</a></li>
							<li><i class="icon icon-phone2"></i><a href="tel:09123456780" class="footer-link">تلفن: 09123456780</a></li>
						</ul>
					</div>
					<div class="col-md-3">
						<h5 class="footer-heading">دسترسی سریع</h5>
						<ul class="list-unstyled nav-links">
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">خانه</a></li>
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">راهنمای محاسبه گر</a></li>
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">تماس با ما</a></li>
						</ul>
					</div>
					<div class="col-md-3">
						<h5 class="footer-heading">از ما بخواهید</h5>
						<ul class="list-unstyled nav-links">
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">خدمات مشاوره</a></li>
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">ثبت سفارش</a></li>
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">بهترین پیشنهاد</a></li>
						</ul>
					</div>
					
					<div class="col-md-2">
						<h5 class="footer-heading">شبکه های اجتماعی</h5>
						<ul class="list-unstyled social-links">
							<li><a href="https://facebook.com" class="social-link" target="_blank"><i class="icon icon-facebook"></i></a></li>
							<li><a href="https://twitter.com" class="social-link" target="_blank"><i class="icon icon-twitter"></i></a></li>
							<li><a href="https://instagram.com" class="social-link" target="_blank"><i class="icon icon-instagram"></i></a></li>
							<li><a href="https://pinterest.com" class="social-link" target="_blank"><i class="icon icon-pinterest"></i></a></li>
						</ul>
					</div>
				</div>
				<hr>
				<div class="row">
					<div class="col-md-8">
						<ul id="subFooterLinks">
							<li><a href="#" target="_blank">فایل راهنما</a></li>
							<li><a href="#" target="_blank">ویدئوی راهنما</a></li>
							<li><a href="#">تصاویر</a></li>
						</ul>
					</div>
					<div class="col-md-4">
						<div id="copy">© 2023 Kanotek</div>
					</div>
				</div>
			</div>
		</footer>
		<!-- Footer End -->
	</div>
	<!-- Page End -->

	<!-- Back to top button -->
	<div id="toTop"><i class="fa fa-chevron-up"></i></div>

	<!-- Vendor Javascript Files -->
	<script src="vendor/jquery/jquery.min.js"></script>
	<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
	<script src="vendor/easing/js/easing.min.js"></script>
	<script src="vendor/parsley/js/parsley.min.js"></script>
	<script src="vendor/nice-select/js/jquery.nice-select.min.js"></script>
	<script src="vendor/range-slider/js/ion.rangeSlider.min.js"></script>
	<script src="vendor/price-format/js/jquery.priceformat.min.js"></script>
	<script src="vendor/theia-sticky-sidebar/js/ResizeSensor.min.js"></script>
	<script src="vendor/theia-sticky-sidebar/js/theia-sticky-sidebar.min.js"></script>
	<script src="vendor/mmenu/js/mmenu.min.js"></script>
	<script src="vendor/magnific-popup/js/jquery.magnific-popup.min.js"></script>
	<script src="vendor/float-labels/js/float-labels.min.js"></script>

	<!-- Main Javascript File -->
	<script src="js/scripts-2.js"></script>

</body>

</html>