<!DOCTYPE html>
<html lang="fa">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="description" content="Kanotek Calculator and Order Wizard">
	<meta name="author" content="Kanotek.ir">
	<title>محاسبه گر | هزینه پروفیل درب و پنجره</title>

	<!-- Favicon -->
	<link href="img/favicon.ico" rel="shortcut icon">

	<!-- Google Fonts - Poppins, Karla -->
	<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Karla:300,400,500,600,700" rel="stylesheet">

	<!-- Font Awesome CSS -->
	<link href="vendor/fontawesome/css/all.min.css" rel="stylesheet">

	<!-- Custom Font Icons -->
	<link href="vendor/icomoon/css/iconfont.min.css" rel="stylesheet">

	<!-- Vendor CSS -->
	<link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
	<link href="vendor/animate/css/animate.min.css" rel="stylesheet">
	<link href="vendor/dmenu/css/menu.css" rel="stylesheet">
	<link href="vendor/hamburgers/css/hamburgers.min.css" rel="stylesheet">
	<link href="vendor/mmenu/css/mmenu.min.css" rel="stylesheet">
	<link href="vendor/range-slider/css/ion.rangeSlider.css" rel="stylesheet">
	<link href="vendor/magnific-popup/css/magnific-popup.css" rel="stylesheet">
	<link href="vendor/float-labels/css/float-labels.min.css" rel="stylesheet">

	<!-- Main CSS -->
	<link href="css/style.css" rel="stylesheet">

</head>

<body>

	<!-- Preloader -->
	<div id="preloader">
		<div data-loader="circle-side"></div>
	</div>
	<!-- Preloader End -->

	<!-- Page -->
	<div id="page">
		<!-- Header -->
		<header class="main-header sticky">
			<a href="#menu" class="btn-mobile">
				<div class="hamburger hamburger--spin" id="hamburger">
					<div class="hamburger-box">
						<div class="hamburger-inner"></div>
					</div>
				</div>
			</a>
			<div class="container">
				<div class="row">
					<div class="col-lg-3 col-6">
						<div id="logo">
							<h1><a href="index.php" title="Kanotek"> </a></h1>
						</div>
					</div>
					<div class="col-lg-9 col-6">
						<ul id="menuIcons">
							<li><a href="#"><i class="icon icon-support"></i></a></li>
							<li><a href="#"><i class="icon icon-shopping-cart2"></i></a></li>
						</ul>
						<!-- Menu -->
						<nav id="menu" class="main-menu">
							<ul>
								<li><span><a href="index.php">خانه</a></span></li>
								<li><span><a href="#">راهنمای محاسبه گر</a></span></li>
								<li><span><a href="calculator-2.php">محاسبه گر</a></span></li>
								<li><span><a href="contacts.php">تماس با ما</a></span></li>
							</ul>
						</nav>
						<!-- Menu End -->
					</div>
				</div>
			</div>
		</header>
		<!-- Header End -->

		<!-- Sub Header -->
		<div class="sub-header">
			<div class="container">
				<h1>تماس با ما</h1>
			</div>
		</div>
		<!-- Sub Header End -->

		<main>
			<!-- Map -->
			<div  class="map map_single"><iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3237.549947611999!2d51.415926074571566!3d35.76186507256135!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3f8e06862496eb29%3A0xd8943e452638c102!2sTehran%20Province%2C%20Tehran%2C%20Nelson%20Mandela%20Blvd%2C%20Iran!5e0!3m2!1sen!2s!4v1689051839037!5m2!1sen!2s" width="100%" height="500" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe></div>

			<!-- Contacts -->
			<div class="contacts">
				<div class="container">
					<div class="text-center">
						<h2>راه های ارتباط با ما</h2>
						<div class="border-multiple">
							<span class="first"></span>
							<span class="second"></span>
							<span class="third"></span>
						</div>
						<div class="row">
							<div class="col-lg-8 mx-auto">
								<p class="lead">شما با انتخابچند گزینه ساده و تعیین اندازه پنجره به قیمت تقریبی پنجره های جدید دست خواهید یافت.</p>
							</div>
						</div>
					</div>
					<div class="mt-5">
						<div class="row">
							<div class="col-lg-4">
								<a href="#" target="_blank">
									<div class="box text-center">
										<div class="icon d-flex align-items-end"><i class="icon icon-map-marker"></i></div>
										<h3 class="contact-title">آدرس</h3>
										<p>تهران، جردن بابک بهرامی پلاک 18</p>
									</div>
								</a>
							</div>
							<div class="col-lg-4">
								<a href="mailto:info@kanotek.ir">
									<div class="box text-center">
										<div class="icon d-flex align-items-end"><i class="icon icon-email"></i></div>
										<h3 class="contact-title">ایمیل</h3>
										<p>info@kanotek.ir</p>
									</div>
								</a>
							</div>
							<div class="col-lg-4">
								<a href="tel:09123456780">
									<div class="box text-center">
										<div class="icon d-flex align-items-end"><i class="icon icon-phone-handset"></i></div>
										<h3 class="contact-title">تلفن</h3>
										<p>09123456780</p>
									</div>
								</a>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- Contacts End -->
		</main>
		<!-- Main End -->

		<!-- Footer -->
		<footer class="main-footer">
			<div class="container">
				<div class="row">
					<div class="col-md-4">
						<h5 class="footer-heading">تماس با ما</h5>
						<ul class="list-unstyled contact-links">
							<li><i class="icon icon-map-marker"></i><a href="https://goo.gl/maps/vKgGyZe2JSRLDnYH6" class="footer-link" target="_blank">آدرس: تهران جردن بابک بهرامی پلاک 18</a>
							</li>
							<li><i class="icon icon-envelope3"></i><a href="mailto:info@kanotek.ir" class="footer-link">ایمیل: info@kanotek.ir</a></li>
							<li><i class="icon icon-phone2"></i><a href="tel:09123456780" class="footer-link">تلفن: 09123456780</a></li>
						</ul>
					</div>
					<div class="col-md-3">
						<h5 class="footer-heading">دسترسی سریع</h5>
						<ul class="list-unstyled nav-links">
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">خانه</a></li>
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">راهنمای محاسبه گر</a></li>
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">تماس با ما</a></li>
						</ul>
					</div>
					<div class="col-md-3">
						<h5 class="footer-heading">از ما بخواهید</h5>
						<ul class="list-unstyled nav-links">
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">خدمات مشاوره</a></li>
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">ثبت سفارش</a></li>
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">بهترین پیشنهاد</a></li>
						</ul>
					</div>
					
					<div class="col-md-2">
						<h5 class="footer-heading">شبکه های اجتماعی</h5>
						<ul class="list-unstyled social-links">
							<li><a href="https://facebook.com" class="social-link" target="_blank"><i class="icon icon-facebook"></i></a></li>
							<li><a href="https://twitter.com" class="social-link" target="_blank"><i class="icon icon-twitter"></i></a></li>
							<li><a href="https://instagram.com" class="social-link" target="_blank"><i class="icon icon-instagram"></i></a></li>
							<li><a href="https://pinterest.com" class="social-link" target="_blank"><i class="icon icon-pinterest"></i></a></li>
						</ul>
					</div>
				</div>
				<hr>
				<div class="row">
					<div class="col-md-8">
						<ul id="subFooterLinks">
							<li><a href="#" target="_blank">فایل راهنما</a></li>
							<li><a href="#" target="_blank">ویدئوی راهنما</a></li>
							<li><a href="#">تصاویر</a></li>
						</ul>
					</div>
					<div class="col-md-4">
						<div id="copy">© 2023 Kanotek</div>
					</div>
				</div>
			</div>
		</footer>
		<!-- Footer End -->
	</div>
	<!-- Page End -->

	<!-- Back to top button -->
	<div id="toTop"><i class="fa fa-chevron-up"></i></div>

	<!-- Vendor Javascript Files -->
	<script src="vendor/jquery/jquery.min.js"></script>
	<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
	<script src="vendor/easing/js/easing.min.js"></script>
	<script src="vendor/parsley/js/parsley.min.js"></script>
	<script src="vendor/nice-select/js/jquery.nice-select.min.js"></script>
	<script src="vendor/range-slider/js/ion.rangeSlider.min.js"></script>
	<script src="vendor/price-format/js/jquery.priceformat.min.js"></script>
	<script src="vendor/theia-sticky-sidebar/js/ResizeSensor.min.js"></script>
	<script src="vendor/theia-sticky-sidebar/js/theia-sticky-sidebar.min.js"></script>
	<script src="vendor/mmenu/js/mmenu.min.js"></script>
	<script src="vendor/magnific-popup/js/jquery.magnific-popup.min.js"></script>
	<script src="vendor/float-labels/js/float-labels.min.js"></script>

	<!-- Map -->
	<script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY"></script>
	<script src="vendor/infobox/js/infobox.js"></script>
	<script src="js/map.js"></script>

	<!-- Main Javascript File -->
	<script src="js/scripts.js"></script>

</body>

</html>