<!DOCTYPE html>
<html lang="fa">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="description" content="Kanotek Calculator and Order Wizard">
	<meta name="author" content="Kanotek.ir">
	<title>محاسبه گر | هزینه پروفیل درب و پنجره</title>

	<!-- Favicon -->
	<link href="img/favicon.ico" rel="shortcut icon">

	<!-- Google Fonts - Poppins, Karla -->
	<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Karla:300,400,500,600,700" rel="stylesheet">

	<!-- Font Awesome CSS -->
	<link href="vendor/fontawesome/css/all.min.css" rel="stylesheet">

	<!-- Custom Font Icons -->
	<link href="vendor/icomoon/css/iconfont.min.css" rel="stylesheet">

	<!-- Vendor CSS -->
	<link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
	<link href="vendor/animate/css/animate.min.css" rel="stylesheet">
	<link href="vendor/dmenu/css/menu.css" rel="stylesheet">
	<link href="vendor/hamburgers/css/hamburgers.min.css" rel="stylesheet">
	<link href="vendor/mmenu/css/mmenu.min.css" rel="stylesheet">
	<link href="vendor/range-slider/css/ion.rangeSlider.css" rel="stylesheet">
	<link href="vendor/magnific-popup/css/magnific-popup.css" rel="stylesheet">
	<link href="vendor/float-labels/css/float-labels.min.css" rel="stylesheet">

	<!-- Main CSS -->
	<link href="css/style.css" rel="stylesheet">

</head>

<body>

	<!-- Preloader -->
	<div id="preloader">
		<div data-loader="circle-side"></div>
	</div>
	<!-- Preloader End -->

	<!-- Page -->
	<div id="page">
		<!-- Header -->
		<header class="main-header sticky">
			<a href="#menu" class="btn-mobile">
				<div class="hamburger hamburger--spin" id="hamburger">
					<div class="hamburger-box">
						<div class="hamburger-inner"></div>
					</div>
				</div>
			</a>
			<div class="container">
				<div class="row">
					<div class="col-lg-3 col-6">
						<div id="logo">
							<h1><a href="index.php" title="Kanotek"> </a></h1>
						</div>
					</div>
					<div class="col-lg-9 col-6">
						<ul id="menuIcons">
							<li><a href="#"><i class="icon icon-support"></i></a></li>
							<li><a href="#"><i class="icon icon-shopping-cart2"></i></a></li>
						</ul>
						<!-- Menu -->
						<nav id="menu" class="main-menu">
							<ul>
								<li><span><a href="index.php">خانه</a></span></li>
								<li><span><a href="#">راهنمای محاسبه گر</a></span></li>
								<li><span><a href="calculator-2.php">محاسبه گر</a></span></li>
								<li><span><a href="contacts.php">تماس با ما</a></span></li>
							</ul>
						</nav>
						<!-- Menu End -->
					</div>
				</div>
			</div>
		</header>
		<!-- Header End -->

		<main>
			<!-- Hero -->
			<div class="hero-home bg-mockup">
				<div class="content">
					<h3>محاسبه گر </h3>
					<p>هزینه پروفیل درب و پنجره</p>
					<a href="calculator-2.php" class="btn-1 medium">حساب کن!</a>
				</div>
			</div>
			<!-- Hero End -->

			<!-- Services -->
			<div class="services">
				<div class="container">
					<div class="text-center">
						<h2>آشنایی با محاسبه گر</h2>
						<div class="border-multiple">
							<span class="first"></span>
							<span class="second"></span>
							<span class="third"></span>
						</div>
						<div class="row">
							<div class="col-lg-8 mx-auto">
								<p class="lead">محاسبه گر هزینه پروفیل درب و پنجره بسادگی می تواند تخمین خوبی از میزان هزینه احتمالی شما برای تعویض پنجره های قدیمی شما داشته باشد</p>
							</div>
						</div>
					</div>
					<div class="mt-5">
						<div class="row">
							<div class="col-lg-4">
								<a href="calculator-2.php" class="service-link">
									<div class="box text-center">
										<div class="icon d-flex align-items-end"><i class="icon icon-calculator-1 color-1"></i></div>
										<h3 class="service-title">خدمات محاسبه گر</h3>
										<p>یکی از خدماتی که به شما ارائه می کنیم در مورد محاسبات قیمت پروفیل می باشد.</p>
									</div>
								</a>
							</div>
							<div class="col-lg-4">
								<a href="#" class="service-link">
									<div class="box text-center">
										<div class="icon d-flex align-items-end"><i class="icon icon-shopping-cart-1 color-2"></i></div>
										<h3 class="service-title">ثبت سفارش</h3>
										<p>یکی از خدماتی که به شما  ارائه می کنیم در مورد نحوه سفارش می باشد..</p>
									</div>
								</a>
							</div>
							<div class="col-lg-4">
								<a href="calculator-2.php" class="service-link">
									<div class="box text-center">
										<div class="icon d-flex align-items-end"><i class="icon icon-email color-3"></i></div>
										<h3 class="service-title">ارسال مستندات</h3>
										<p>یکی از خدماتی که به شما ارائه می کنیم در مورد ارسال مستندات به ایمیل می باشد.</p>
									</div>
								</a>
							</div>
							<div class="col-lg-4">
								<a href="calculator-2.php" class="service-link">
									<div class="box text-center">
										<div class="icon d-flex align-items-end"><i class="icon icon-truck color-3"></i></div>
										<h3 class="service-title">تحویل سفارش</h3>
										<p>یکی از خدماتی که به شما ارائه می کنیم در مورد تحویل به موقع و سریع سفارشات می باشد.</p>
									</div>
								</a>
							</div>
							<div class="col-lg-4">
								<a href="calculator-2.php" class="service-link">
									<div class="box text-center">
										<div class="icon d-flex align-items-end"><i class="icon icon-support color-1"></i></div>
										<h3 class="service-title">پشتیبانی و مشاوره</h3>
										<p>یکی از خدماتی که به  شما ارائه می کنیم در مورد پشتیبانی و مشاوره مشتری می باشد.</p>
									</div>
								</a>
							</div>
							<div class="col-lg-4">
								<a href="calculator-2.php" class="service-link">
									<div class="box text-center">
										<div class="icon d-flex align-items-end"><i class="icon icon-checkmark-circle color-2"></i></div>
										<h3 class="service-title">گارانتی و ضمانت</h3>
										<p>یکی از خدماتی که به شما ارائه می کنیم در مورد گارانتی محصول، می باشد.</p>
									</div>
								</a>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- Services End -->

		</main>
		<!-- Main End -->

		<!-- Footer -->
		<footer class="main-footer">
			<div class="container">
				<div class="row">
					<div class="col-md-4">
						<h5 class="footer-heading">تماس با ما</h5>
						<ul class="list-unstyled contact-links">
							<li><i class="icon icon-map-marker"></i><a href="#" class="footer-link" target="_blank">آدرس: تهران جردن بابک بهرامی پلاک 18</a>
							</li>
							<li><i class="icon icon-envelope3"></i><a href="mailto:info@kanotek.ir" class="footer-link">ایمیل: info@kanotek.ir</a></li>
							<li><i class="icon icon-phone2"></i><a href="tel:09123456780" class="footer-link">تلفن: 09123456780</a></li>
						</ul>
					</div>
					<div class="col-md-3">
						<h5 class="footer-heading">دسترسی سریع</h5>
						<ul class="list-unstyled nav-links">
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">خانه</a></li>
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">راهنمای محاسبه گر</a></li>
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">تماس با ما</a></li>
						</ul>
					</div>
					<div class="col-md-3">
						<h5 class="footer-heading">از ما بخواهید</h5>
						<ul class="list-unstyled nav-links">
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">خدمات مشاوره</a></li>
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">ثبت سفارش</a></li>
							<li><i class="fas fa-angle-left"></i> <a href="#" class="footer-link">بهترین پیشنهاد</a></li>
						</ul>
					</div>
					
					<div class="col-md-2">
						<h5 class="footer-heading">شبکه های اجتماعی</h5>
						<ul class="list-unstyled social-links">
							<li><a href="https://facebook.com" class="social-link" target="_blank"><i class="icon icon-facebook"></i></a></li>
							<li><a href="https://twitter.com" class="social-link" target="_blank"><i class="icon icon-twitter"></i></a></li>
							<li><a href="https://instagram.com" class="social-link" target="_blank"><i class="icon icon-instagram"></i></a></li>
							<li><a href="https://pinterest.com" class="social-link" target="_blank"><i class="icon icon-pinterest"></i></a></li>
						</ul>
					</div>
				</div>
				<hr>
				<div class="row">
					<div class="col-md-8">
						<ul id="subFooterLinks">
							<li><a href="#" target="_blank">فایل راهنما</a></li>
							<li><a href="#" target="_blank">ویدئوی راهنما</a></li>
							<li><a href="#">تصاویر</a></li>
						</ul>
					</div>
					<div class="col-md-4">
						<div id="copy">© 2023 Kanotek</div>
					</div>
				</div>
			</div>
		</footer>
		<!-- Footer End -->
	</div>
	<!-- Page End -->

	<!-- Back to top button -->
	<div id="toTop"><i class="fa fa-chevron-up"></i></div>

	<!-- Vendor Javascript Files -->
	<script src="vendor/jquery/jquery.min.js"></script>
	<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
	<script src="vendor/easing/js/easing.min.js"></script>
	<script src="vendor/parsley/js/parsley.min.js"></script>
	<script src="vendor/nice-select/js/jquery.nice-select.min.js"></script>
	<script src="vendor/range-slider/js/ion.rangeSlider.min.js"></script>
	<script src="vendor/price-format/js/jquery.priceformat.min.js"></script>
	<script src="vendor/theia-sticky-sidebar/js/ResizeSensor.min.js"></script>
	<script src="vendor/theia-sticky-sidebar/js/theia-sticky-sidebar.min.js"></script>
	<script src="vendor/mmenu/js/mmenu.min.js"></script>
	<script src="vendor/magnific-popup/js/jquery.magnific-popup.min.js"></script>
	<script src="vendor/float-labels/js/float-labels.min.js"></script>

	<!-- Main Javascript File -->
	<script src="js/scripts.js"></script>

</body>

</html>