<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;

use File;
use ZipArchive;

class BackController extends Controller
{
    public function index(){
        $users= User::where('is_admin',0)->get();
        return view('Admin.users',compact('users'));
    }

    public function files_back(){
        $users= User::where('is_admin',0)->get();
        return view('Admin.files',compact('users'));
    }

    public function downloadZip(User $user)
    {
        $zip = new ZipArchive;
   
        $fileName = time().'File.zip';
   
        if ($zip->open(public_path($fileName), ZipArchive::CREATE) === TRUE)
        {
            try {
                // $files = File::files([public_path('/uploads/user/id/'.$user->id.'/file2/'),public_path('/uploads/user/id/'.$user->id.'/file1/')]);
                $files = File::files([storage_path('app//user/id/'.$user->id.'/file2/') , storage_path('app//user/id/'.$user->id.'/file1/')]);
                // dd($files);
                
            } catch (\Throwable $th) {
               
                return back()->with('error','There is no file!');
            }
            
   
            foreach ($files as $key => $value) {
                $relativeNameInZipFile = basename($value);
                $zip->addFile($value, $relativeNameInZipFile);
            }
             
            $zip->close();
        }
    
        return response()->download(public_path($fileName));
    }



    public function show_upload_file(User $user){
        return view('Admin.show_upload_file',compact('user'));
    }

    public function upload_file(Request $request,User $user){
        $request->validate([
            'file'=>'required',
        ]);

        try {
            $user_id = $user->id;
            $destinationPath = 'admin/uploads/user/id/'.$user_id.'/file';
            $request->file('file')->store($destinationPath);
            return redirect()->back()->with('success','The file has been uploaded successfully');
        } catch (\Throwable $th) {
                return redirect()->back()->with('error','File upload failed');
            }
    }


    public function change_verify(User $user){
        // dd($user->verify);
        if($user->verify == 0){
            $user->verify = 1;
            $user->save();
            
        } else {
            $user->verify = 0;
            $user->save();
        }

        return redirect()->back();
    }
}
