<?php

namespace App\Http\Controllers;

use App\Events\CreateUser;
use App\Mail\CreatedUser;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Spatie\FlareClient\View;
use Illuminate\Support\Facades\Storage;

use File;
use ZipArchive;

class HomeController extends Controller
{
    

    public function index(){
        return view('main');
    }

    public function allInOne(){
        return view('pages.ALL_IN_ONE_ANALYSIS');
    }

    public function PROJECT_SUMMARY(){
        return view('pages.PROJECT_SUMMARY');
    }



    public function upload_sample_files(Request $request){
     
        $request->validate([
            'file1'=>'required',
            'file2'=>'required',
        ]);

        $user_id = auth()->user()->id;
        

        // $file = $request->file('file1');
        // $destinationPath = 'uploads/user/id/'.$user_id.'/file1';
        // $file->move($destinationPath,time().$file->getClientOriginalName());

        // $file = $request->file('file2');
        // $destinationPath = 'uploads/user/id/'.$user_id.'/file2';
        // $file->move($destinationPath,time().$file->getClientOriginalName());
        
        
        
        
        $destinationPath1 = 'user/id/'.$user_id.'/file1';
        Storage::disk('local')->put($destinationPath1, $request->file1);

        $destinationPath2 = 'user/id/'.$user_id.'/file2';
        Storage::disk('local')->put($destinationPath2, $request->file2);
        
        // $request->file('file1')->store($destinationPath1);
   
        return response()->json(['success'=>'You have successfully upload file.']);
    }



    public function downloadn_result(){
        $zip = new ZipArchive;
   
        $fileName = time().'result.zip';
   
        if ($zip->open(public_path($fileName), ZipArchive::CREATE) === TRUE)
        {
            try {
                // $files = File::files(public_path('/admin/uploads/user/id/'.auth()->user()->id.'/file/'));
                $files = File::files([storage_path('app/admin/uploads/user/id/'.auth()->user()->id.'/file/')]);
               
            } catch (\Throwable $th) {
                return back()->with('error','There is no file!');
            }
            
   
            foreach ($files as $key => $value) {
                $relativeNameInZipFile = basename($value);
                $zip->addFile($value, $relativeNameInZipFile);
            }
             
            $zip->close();
        }
    
        return response()->download(public_path($fileName));
    }


    

    

}
