<?php

namespace App\Listeners;

use App\Events\CreateUser;
use App\Mail\CreatedUser;
use App\Models\User;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Mail;

class CreateUserEmail
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\CreateUser  $event
     * @return void
     */
    public function handle(CreateUser $event)
    {
        $admin = User::where('is_admin',1)->get()->first();
        Mail::to($admin->email)->send(new CreatedUser());
    }
}
