@extends('Admin.index')

@section('content')
<div class="col">
    <div class="border rounded border-3 h-100 p-3">

        @if ($message = Session::get('success'))
        <div class="alert alert-success alert-block">
            <strong>{{ $message }}</strong>
        </div>
        @endif

        @if ($message = Session::get('error'))
        <div class="alert alert-danger alert-block">
            <strong>{{ $message }}</strong>
        </div>
        @endif

        <form action="{{route('upload_file',$user)}}" method="POST" enctype="multipart/form-data" class="p-3">
            @csrf
            <input name="file" type="file" class="form-control">
            @error('file')
                <p class="text-danger">{{$message}}</p>
            @enderror
            <button class="btn btn-primary mt-3" type="submit">upload</button>
        </form>
    </div>
</div>
@endsection