@extends('index')

@section('content')
<div class="page-content">
    <div class="content container">
      <div class="row">
        <div class="col-lg-12">
          <h2 class="page-title">VirPy Pipeline</h2>
        </div>
      </div>
      <div class="row">
        <div class="col-lg-12">
          <div class="widget">

            <div class="widget-header"> <i class="icon-tasks"></i>
              <h3>Multiple Sample File Upload</h3>
            </div>
            <div class="widget-content">

              <div id="examples" class="section examples-section p-3">
                {{-- <div class="col-sm-4 col-md-2"> --}}

                    <div class="alert alert-info">
                        <i class="icon-info-sign"></i> In this version of software, there is not any quality controls on samples files.Please upload high quality samples
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    </div>
                  
                    <p class="mt-3">To get a high quality version of your data you can use FastQC application which aims to provide a simple way to do some quality control checks on raw sequence data coming from high throughput sequencing pipelines. It provides a modular set of analyses which you can use to give a quick impression of whether your data has any problems of which you should be aware before doing any further analysis.</p>
                    <p>You can upload data from Fasta, Zip or FastQ files (any variant)</p>

                    
                    <form id="fileUploadForm" action="{{route('upload_sample_files')}}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <span class="btn btn-success mt-5">
                            <i class="icon-plus"></i>
                            <span>Select Forward sample file</span>
                            <input required type="file" name="file1" >
                            @error('file1')
                              <span class="text-danger">{{$message}}</span>
                            @enderror
                        </span>
                        

                        <br>

                        <span class="btn btn-success mt-3">
                            <i class="icon-plus"></i>
                            <span>Select Reverse sample file</span>
                            <input required type="file" name="file2" >
                            @error('file2')
                              <span class="text-danger">{{$message}}</span>
                            @enderror
                        </span>


                        {{-- <div class="form-group">
                          <div class="progress">
                              <div class="progress-bar progress-bar-striped progress-bar-animated bg-success" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%"></div>
                          </div>
                        </div> --}}

                        <div class="progress progress-striped active mt-3">
                          <div class="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%">
                            <span class="sr-only">45% Complete</span>
                          </div>
                        </div>
                        

                        <div class="mt-5">
                            <button type="submit" class="btn btn-primary start">
                                <i class="icon-upload"></i>
                                <span>Start upload</span>
                            </button>
                        </div>

                    </form>

                    {{-- <div class="mt-2">
                        <a class="btn btn-s-md btn-danger" href="#">Delete files after getting results</a>
                    </div> --}}

                    


                   
                {{-- </div> --}}
                
              </div>



                {{-- <div class="widget">
                    <div class="widget-header"> <i class="icon-tasks"></i>
                        <h3>Files and Run</h3>
                    </div>
                    <div style="position: unset" class="widget-content">
                        <p>Run the pipline after file complete uploades.</p>

                        <div class="control-group mt-3 d-flex">
                            <div class="col-md-3">
                              <label for="normal-field" class="control-label">Forward sample file</label>
                              </div>
                              <div class="col-md-9">
                              <div class="form-group">
                                <input type="text" placeholder="" class="form-control" id="normal-field">
                              </div>
                              </div>
                        </div>


                        <div class="control-group d-flex">
                            <div class="col-md-3">
                              <label for="normal-field" class="control-label">Reverse sample file</label>
                              </div>
                              <div class="col-md-9">
                              <div class="form-group">
                                <input type="text" placeholder="" class="form-control" id="normal-field">
                              </div>
                              </div>
                        </div>

                        <div class="form-group lable-padd d-flex">
                            <div class="col-sm-6 left-align">
                              <div class="checkbox">
                                <label>
                                  <input type="checkbox" value="" required="" name="terms" class="parsley-validated">
                                  Accept Terms &amp; Conditions </label>
                              </div>
                            </div>
                        </div>


                        <div class="panel-footer">
                            <div class="d-flex justify-content-center">
                             
                                  <button class="btn-primary btn" onclick="javascript:$('#validate-form').parsley( 'validate' );">Submit</button>
                                  <button style="margin-left: 1rem" class="btn-default btn">Cancel</button>
                                
                            </div>
                        </div>



                    </div>
                </div> --}}

            </div>


            
            
                

          </div>
        </div>
      </div>
    </div>
  </div>
@endsection