<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\BackController;
use App\Http\Controllers\HomeController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['prefix' => 'back_admin','middleware' => 'is_admin'], function () {
    Route::get('/',[BackController::class,'index'])->name('home_back');
    Route::get('/files',[BackController::class,'files_back'])->name('files_back');
    Route::get('/downloadZip/{user}',[BackController::class,'downloadZip'])->name('downloadZip');
    
    Route::get('/change-verify/{user}',[BackController::class,'change_verify'])->name('change_verify');

    Route::get('/show/upload-file/{user}',[BackController::class,'show_upload_file'])->name('show_upload_file');
    Route::post('/upload-file/{user}',[BackController::class,'upload_file'])->name('upload_file');
});

Route::group(['middleware' => 'verify'], function () {
    Route::get('/',[HomeController::class,'index'])->name('home');
    Route::get('/all-in-one',[HomeController::class,'allInOne'])->name('allInOne');
    Route::get('/project-summary',[HomeController::class,'PROJECT_SUMMARY'])->name('PROJECT_SUMMARY');
    Route::get('/download-result',[HomeController::class,'downloadn_result'])->name('downloadn_result');
    Route::post('/upload_sample_files',[HomeController::class,'upload_sample_files'])->name('upload_sample_files');
});



Route::get('/register',[AuthController::class,'register_show'])->name('register_show')->middleware('guest');
Route::post('/register',[AuthController::class,'register'])->name('register');

Route::get('/login',[AuthController::class,'login_show'])->name('login_show')->middleware('guest');
Route::post('/login',[AuthController::class,'login'])->name('login');

Route::get('/logout',[AuthController::class,'logout'])->name('logout');



